/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.impl.capture;

import com.scandit.datacapture.barcode.impl.capture.NativeBarcodeCaptureListener;
import com.scandit.datacapture.barcode.impl.capture.NativeBarcodeCaptureSession;
import com.scandit.datacapture.barcode.impl.capture.NativeBarcodeCaptureSettings;
import com.scandit.datacapture.core.impl.capture.NativeDataCaptureContext;
import com.scandit.datacapture.core.impl.capture.NativeDataCaptureMode;
import com.scandit.datacapture.core.impl.capture.NativeFeedback;
import com.scandit.datacapture.core.impl.common.async.NativeWrappedFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcodeCapture {
    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public abstract NativeWrappedFuture applySettingsWrapped(NativeBarcodeCaptureSettings var1);

    public abstract void addListenerAsync(NativeBarcodeCaptureListener var1);

    public abstract void removeListenerAsync(NativeBarcodeCaptureListener var1);

    public abstract NativeDataCaptureMode asDataCaptureMode();

    public abstract NativeBarcodeCaptureSession getSession();

    public abstract NativeDataCaptureContext getContext();

    public abstract void setSuccessFeedback(NativeFeedback var1);

    public static NativeBarcodeCapture create(NativeDataCaptureContext context, NativeBarcodeCaptureSettings settings) {
        return CppProxy.create(context, settings);
    }

    private static final class CppProxy
    extends NativeBarcodeCapture {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public boolean isEnabled() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isEnabled(this.nativeRef);
        }

        private native boolean native_isEnabled(long var1);

        @Override
        public void setEnabled(boolean enabled) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setEnabled(this.nativeRef, enabled);
        }

        private native void native_setEnabled(long var1, boolean var3);

        @Override
        public NativeWrappedFuture applySettingsWrapped(NativeBarcodeCaptureSettings settings) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_applySettingsWrapped(this.nativeRef, settings);
        }

        private native NativeWrappedFuture native_applySettingsWrapped(long var1, NativeBarcodeCaptureSettings var3);

        @Override
        public void addListenerAsync(NativeBarcodeCaptureListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_addListenerAsync(this.nativeRef, listener);
        }

        private native void native_addListenerAsync(long var1, NativeBarcodeCaptureListener var3);

        @Override
        public void removeListenerAsync(NativeBarcodeCaptureListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_removeListenerAsync(this.nativeRef, listener);
        }

        private native void native_removeListenerAsync(long var1, NativeBarcodeCaptureListener var3);

        @Override
        public NativeDataCaptureMode asDataCaptureMode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_asDataCaptureMode(this.nativeRef);
        }

        private native NativeDataCaptureMode native_asDataCaptureMode(long var1);

        @Override
        public NativeBarcodeCaptureSession getSession() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getSession(this.nativeRef);
        }

        private native NativeBarcodeCaptureSession native_getSession(long var1);

        @Override
        public NativeDataCaptureContext getContext() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getContext(this.nativeRef);
        }

        private native NativeDataCaptureContext native_getContext(long var1);

        @Override
        public void setSuccessFeedback(NativeFeedback feedback) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setSuccessFeedback(this.nativeRef, feedback);
        }

        private native void native_setSuccessFeedback(long var1, NativeFeedback var3);

        public static native NativeBarcodeCapture create(NativeDataCaptureContext var0, NativeBarcodeCaptureSettings var1);
    }
}

