/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericUtilityMethods {
    static final Logger logger = LoggerFactory.getLogger(GenericUtilityMethods.class);

    private GenericUtilityMethods() {
        throw new IllegalStateException("Should not instantiate utility class");
    }

    public static ByteArrayOutputStream getOutputStreamFromInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        if (is != null) {
            int len;
            while ((len = is.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
        }
        baos.flush();
        return baos;
    }

    public static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("Error while closing the input stream", (Throwable)e);
            }
        }
    }
}

