/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.sap.cloud.sdk.service.prov.api.security.Authorization;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationDecorator;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationRulesContainer;

public class BackwardCompatibility
extends AuthorizationDecorator {
    private Authorization authorization;

    public BackwardCompatibility(Authorization authorization) {
        super(authorization);
        this.authorization = authorization;
    }

    @Override
    public boolean isAuthenticatedUser(String serviceName) {
        if (AuthorizationRulesContainer.isRuleExist(serviceName)) {
            return this.authorization.isAuthenticatedUser(serviceName);
        }
        return true;
    }

    @Override
    public boolean isRegisteredUser(String serviceName) {
        if (AuthorizationRulesContainer.isRuleExist(serviceName)) {
            return this.authorization.isRegisteredUser(serviceName);
        }
        return true;
    }

    @Override
    public boolean hasEntityAccess(String entityName, String operation) {
        if (AuthorizationRulesContainer.isRuleExist(entityName)) {
            return this.authorization.hasEntityAccess(entityName, operation);
        }
        return true;
    }
}

