/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.service.prov.api.internal.CSNUtil;
import com.sap.cloud.sdk.service.prov.api.internal.SQLMapping;
import com.sap.cloud.sdk.service.prov.api.security.CaseInsensitiveString;
import com.sap.cloud.sdk.service.prov.api.security.InfixParam;
import com.sap.cloud.sdk.service.prov.api.security.InfixSQL;
import com.sap.cloud.sdk.service.prov.api.security.JWTUtil;
import com.sap.cloud.sdk.service.prov.api.security.Operand;
import com.sap.cloud.sdk.service.prov.api.security.Operator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;

public class AuthorizationExpressionParser {
    private static final String $ = "$";
    private static final int ONE = 1;
    private static final String LEFT_PARANTHESIS = "(";
    private static final String RIGHT_PARANTHESIS = ")";
    private static final String LEFT_CURLY_PARANTHESIS = " { ";
    private static final String RIGHT_CURLY_PARANTHESIS = " } ";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String HANA_PARAM_PLACEHOLDER = "?";
    private static final String ALIAS_Prefix = "ROOT_ENTITY_SELECT_ALIAS.PATH_FROM_ROOT.";
    private static final String NULL = "null";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String NOT = "not";
    private static final String WHERE = " where ";
    private static final String FROM = " from ";
    private static final String SELECT = " select ";
    private static String ALIAS = " AS ZZ";

    public static String[] tokenizer(String exp2) {
        String exp = exp2.trim().replaceAll(Operator.GT_EQ.getValue(), Operator.GT_EQ.getEncodedValue()).replaceAll(Operator.ST_EQ.getValue(), Operator.ST_EQ.getEncodedValue()).replaceAll(Operator.GT.getValue(), Operator.GT.getEncodedValue()).replaceAll(Operator.ST.getValue(), Operator.ST.getEncodedValue()).replaceAll(Operator.NOT_EQ.getValue(), Operator.NOT_EQ.getEncodedValue()).replaceAll(Operator.EQ.getValue(), Operator.EQ.getEncodedValue()).replaceAll(Operator.NOT.getValue(), Operator.NOT.getEncodedValue());
        String delims = "(?=\\()|(?<=\\()|(?=\\))|(?<=\\))|(?=\\s)|(?<=\\s)|(?=,)|(?<=,)";
        delims = delims + "|(?=" + Operator.GT.getEncodedValue() + ")|(?<=" + Operator.GT.getEncodedValue() + RIGHT_PARANTHESIS;
        delims = delims + "|(?=" + Operator.GT_EQ.getEncodedValue() + ")|(?<=" + Operator.GT_EQ.getEncodedValue() + RIGHT_PARANTHESIS;
        delims = delims + "|(?=" + Operator.ST.getEncodedValue() + ")|(?<=" + Operator.ST.getEncodedValue() + RIGHT_PARANTHESIS;
        delims = delims + "|(?=" + Operator.ST_EQ.getEncodedValue() + ")|(?<=" + Operator.ST_EQ.getEncodedValue() + RIGHT_PARANTHESIS;
        delims = delims + "|(?=" + Operator.NOT_EQ.getEncodedValue() + ")|(?<=" + Operator.NOT_EQ.getEncodedValue() + RIGHT_PARANTHESIS;
        delims = delims + "|(?=" + Operator.EQ.getEncodedValue() + ")|(?<=" + Operator.EQ.getEncodedValue() + RIGHT_PARANTHESIS;
        delims = delims + "|(?=" + Operator.NOT.getEncodedValue() + ")|(?<=" + Operator.NOT.getEncodedValue() + RIGHT_PARANTHESIS;
        String[] tokens = exp.split(delims);
        return tokens;
    }

    public static boolean transformValueAndCheckIfSpecial(String[] tokens, JsonObject userAttributes) {
        Map<String, Operator> encodedOperatorMap = Operator.getEncodedValueMap();
        boolean isSpecial = false;
        boolean isNull = false;
        boolean paran = false;
        boolean orParam = false;
        int k = 0;
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].startsWith($)) {
                isNull = false;
                tokens[i] = AuthorizationExpressionParser.replaceUserAttributeWithValue(tokens, i, userAttributes);
                if (tokens[i] == null) {
                    isNull = true;
                    paran = false;
                    orParam = false;
                    tokens[i] = SPACE;
                    if (i < tokens.length - 1 && !isSpecial) {
                        while (!tokens[i].equals(AND) && !tokens[i].equals(OR)) {
                            if (!tokens[i].contains(LEFT_PARANTHESIS) && !tokens[i].contains(RIGHT_PARANTHESIS)) {
                                tokens[i] = SPACE;
                            }
                            if (++i <= tokens.length - 1) continue;
                            return isSpecial;
                        }
                        if (tokens[i].equals(AND) || tokens[i].equals(OR)) {
                            tokens[i] = SPACE;
                        }
                    } else {
                        if (isSpecial) {
                            for (k = i; !(tokens[k].equals(AND) || tokens[k].equals(OR) || k == tokens.length - 1 || tokens[k].contains(LEFT_PARANTHESIS) || tokens[k].contains(RIGHT_PARANTHESIS)); ++k) {
                            }
                            if (tokens[k].contains(LEFT_PARANTHESIS) || tokens[k].contains(RIGHT_PARANTHESIS)) {
                                paran = true;
                            }
                            if (!(tokens[k].contains(LEFT_PARANTHESIS) || tokens[k].contains(RIGHT_PARANTHESIS) || tokens[k].contains(OR))) {
                                tokens[k] = SPACE;
                            }
                        }
                        if (tokens[i = k].equals(OR)) {
                            orParam = true;
                            while (!tokens[i].contains(LEFT_PARANTHESIS) && !tokens[i].contains(RIGHT_PARANTHESIS)) {
                                tokens[i] = SPACE;
                                if (++i <= tokens.length - 1) continue;
                            }
                            i = k;
                        }
                        while (i >= 0 && !tokens[i].equals(AND) && !tokens[i].equals(OR)) {
                            if (!tokens[i].contains(LEFT_PARANTHESIS) && !tokens[i].contains(RIGHT_PARANTHESIS)) {
                                tokens[i] = SPACE;
                            }
                            if (i == 0) break;
                            --i;
                        }
                        if (k == tokens.length - 1 && (tokens[i].equals(AND) || tokens[i].equals(OR)) || paran || orParam && !tokens[i].contains(LEFT_PARANTHESIS) && !tokens[i].contains(RIGHT_PARANTHESIS)) {
                            tokens[i] = SPACE;
                        }
                        if (k == tokens.length - 1) {
                            return isSpecial;
                        }
                        i = k + 1;
                    }
                }
                if (!(AuthorizationExpressionParser.isNumeric(tokens[i]) || isNull || tokens[i].startsWith(Operator.IN.getValue()) || tokens[i].startsWith(Operator.IS.getValue()))) {
                    tokens[i] = "'" + tokens[i] + "'";
                }
            } else if (encodedOperatorMap.get(tokens[i]) != null) {
                tokens[i] = encodedOperatorMap.get(tokens[i]).getValue();
            }
            if (isSpecial) continue;
            isSpecial = AuthorizationExpressionParser.isContinsAlpha(tokens[i]);
        }
        return isSpecial;
    }

    private static String replaceUserAttributeWithValue(String[] tokens, int index, JsonObject userAttributes) {
        String curOperand = tokens[index];
        if (curOperand.startsWith($)) {
            int size;
            String updatedOperand = curOperand.substring(1);
            String[] atttibuteKeys = updatedOperand.split("\\.", 2);
            String attributeKey = atttibuteKeys[size = atttibuteKeys.length - 1];
            JsonElement value = userAttributes.get(attributeKey);
            if (value == null) {
                value = JWTUtil.getValueForAnyAttributeFromJWT(attributeKey);
            }
            if (null != value) {
                if (value.isJsonArray()) {
                    JsonArray values = value.getAsJsonArray();
                    if (values.size() == 1) {
                        curOperand = value.getAsJsonArray().get(0).getAsString();
                    } else if (values.size() >= 2) {
                        int temp = index;
                        while (!Operator.EQ.getValue().equals(tokens[temp])) {
                            --temp;
                        }
                        tokens[temp] = SPACE;
                        HashSet<String> valuesSet = new HashSet<String>();
                        for (int i = 0; i < values.size(); ++i) {
                            valuesSet.add(values.get(i).getAsString());
                        }
                        Iterator itr = valuesSet.iterator();
                        StringBuilder sb = new StringBuilder(Operator.IN.getValue());
                        sb.append(LEFT_PARANTHESIS);
                        int count = 1;
                        int valSize = valuesSet.size();
                        while (itr.hasNext()) {
                            String attrVal = (String)itr.next();
                            if (AuthorizationExpressionParser.isNumeric(attrVal)) {
                                if (count != valSize) {
                                    sb.append(attrVal + COMMA);
                                } else {
                                    sb.append(attrVal);
                                }
                            } else if (count != valSize) {
                                sb.append("'" + attrVal + "'" + COMMA);
                            } else {
                                sb.append("'" + attrVal + "'");
                            }
                            ++count;
                        }
                        sb.append(RIGHT_PARANTHESIS);
                        curOperand = sb.toString();
                    } else {
                        curOperand = null;
                    }
                } else {
                    curOperand = value.getAsString();
                }
            } else {
                curOperand = null;
            }
        }
        return curOperand;
    }

    public static StringBuilder convertToPseudoSql(String[] tokens) {
        StringBuilder sb = new StringBuilder("");
        if (tokens.length == 0) {
            return sb;
        }
        sb.append(LEFT_PARANTHESIS);
        for (int i = 0; i < tokens.length - 1; ++i) {
            if (tokens[i].equals(SPACE)) continue;
            sb.append(tokens[i] + SPACE);
        }
        sb.append(tokens[tokens.length - 1]);
        sb.append(RIGHT_PARANTHESIS);
        if (sb.substring(sb.indexOf(LEFT_PARANTHESIS) + 1, sb.lastIndexOf(RIGHT_PARANTHESIS)).equals(SPACE) || sb.substring(sb.indexOf(LEFT_PARANTHESIS) + 1, sb.lastIndexOf(RIGHT_PARANTHESIS)).matches("[( )]+")) {
            return null;
        }
        return sb;
    }

    public static Queue<Object> infixToPostfix(String exp) {
        String[] tokens = AuthorizationExpressionParser.tokenizer(exp);
        Map<String, Operator> encodedOpMap = Operator.getEncodedValueMap();
        Map<String, Operator> valueOpMap = Operator.getValueMap();
        LinkedList<Object> resultSt = new LinkedList<Object>();
        Stack<Object> expSt = new Stack<Object>();
        String token = null;
        for (int index = 0; index < tokens.length; ++index) {
            int temp;
            token = tokens[index];
            if (LEFT_PARANTHESIS.equals(token)) {
                expSt.push(LEFT_PARANTHESIS);
                continue;
            }
            if (RIGHT_PARANTHESIS.equals(token)) {
                while (!(expSt.isEmpty() || expSt.peek() instanceof String && LEFT_PARANTHESIS.equals(expSt.peek()))) {
                    resultSt.add(expSt.pop());
                }
                expSt.pop();
                continue;
            }
            if (token.startsWith("#") && encodedOpMap.get(token.toUpperCase()) != null) {
                AuthorizationExpressionParser.processOperator(encodedOpMap.get(token.toUpperCase()), resultSt, expSt);
                continue;
            }
            if (token.startsWith("'") && !token.endsWith("'")) {
                StringBuilder tempSb = new StringBuilder(token);
                temp = index;
                ++temp;
                while (!tokens[temp].endsWith("'")) {
                    tempSb.append(tokens[temp]);
                    ++temp;
                }
                tempSb.append(tokens[temp]);
                index = temp;
                resultSt.add(new Operand(tempSb.toString()));
                continue;
            }
            if (valueOpMap.get(token.toUpperCase()) != null) {
                Operator opr = valueOpMap.get(token.toUpperCase());
                if (opr == Operator.IN) {
                    temp = index;
                    while (!LEFT_PARANTHESIS.equals(tokens[temp])) {
                        ++temp;
                    }
                    StringBuilder tempSb = new StringBuilder("");
                    while (!RIGHT_PARANTHESIS.equals(tokens[temp])) {
                        tempSb.append(tokens[temp]);
                        ++temp;
                    }
                    tempSb.append(tokens[temp]);
                    index = temp;
                    resultSt.add(new Operand(tempSb.toString()));
                }
                AuthorizationExpressionParser.processOperator(valueOpMap.get(token.toUpperCase()), resultSt, expSt);
                continue;
            }
            if (SPACE.equals(token)) continue;
            resultSt.add(new Operand(token));
        }
        while (!expSt.isEmpty()) {
            resultSt.add(expSt.pop());
        }
        return resultSt;
    }

    public static InfixSQL convertPostfixToInfix(Queue postFixQueue, Map<CaseInsensitiveString, String> propertyTypeMap, boolean isHanaSql, String serviceName, String entityName) {
        if (postFixQueue.isEmpty()) {
            return null;
        }
        LinkedList<InfixParam> infixParams = new LinkedList<InfixParam>();
        String dataType = null;
        String fqSubSelectTable = null;
        String subSelectTable = null;
        HashMap<String, CaseInsensitiveString> propertyNames = new HashMap<String, CaseInsensitiveString>();
        for (CaseInsensitiveString key : propertyTypeMap.keySet()) {
            propertyNames.put(key.getValue().toLowerCase(), key);
        }
        Stack<Operand> stack = new Stack<Operand>();
        while (!postFixQueue.isEmpty()) {
            Object token = postFixQueue.remove();
            if (token instanceof Operand) {
                fqSubSelectTable = AuthorizationExpressionParser.getSubSelectTable(serviceName, token, fqSubSelectTable, stack);
                stack.push((Operand)token);
                continue;
            }
            Operand operand1 = (Operand)stack.pop();
            Operand operand2 = stack.pop();
            Operand temp = operand1;
            if (propertyTypeMap.get(new CaseInsensitiveString(operand1.getValue())) == null) {
                operand1 = operand2;
                operand2 = temp;
            }
            CaseInsensitiveString currentColoumnName = null;
            String currentColoumnPropertyName = null;
            subSelectTable = fqSubSelectTable != null ? fqSubSelectTable.split("[\\._]")[1] : null;
            Operator opr = (Operator)((Object)token);
            boolean isNamespaceQualified = false;
            if (!operand1.getValue().startsWith(LEFT_PARANTHESIS)) {
                String[] values = operand1.getValue().split("\\.");
                currentColoumnName = new CaseInsensitiveString(values[values.length - 1]);
                if (fqSubSelectTable != null && (operand1.getValue().contains(subSelectTable) || CSNUtil.getAllColumns(serviceName, subSelectTable).contains(currentColoumnName.getValue()))) {
                    dataType = AuthorizationExpressionParser.getColumnDataTypeFromCSN(serviceName, subSelectTable, currentColoumnName);
                    currentColoumnPropertyName = fqSubSelectTable + "." + currentColoumnName.getValue().toLowerCase();
                    isNamespaceQualified = true;
                } else if (operand1.getValue().contains(entityName) || propertyNames.get(currentColoumnName.getValue().toLowerCase()) != null) {
                    dataType = propertyTypeMap.get(currentColoumnName);
                    currentColoumnPropertyName = AuthorizationExpressionParser.getColumnNameFromOuterEntity(serviceName, entityName, dataType, propertyNames, currentColoumnName, currentColoumnPropertyName);
                    isNamespaceQualified = true;
                }
                if (isHanaSql) {
                    operand1 = isNamespaceQualified ? new Operand(currentColoumnPropertyName).getOperandWithoutAlisCDS(SQLMapping.isPlainSqlMapping()) : new Operand(currentColoumnPropertyName).getOperandWithPrefixedAlias(ALIAS_Prefix, SQLMapping.isPlainSqlMapping());
                } else {
                    Operand operand = operand1 = isNamespaceQualified ? new Operand(currentColoumnPropertyName).getOperandWithoutAlisCDS(SQLMapping.isPlainSqlMapping()) : operand1.getOperandWithPrefixedAliasCDS(ALIAS_Prefix, SQLMapping.isPlainSqlMapping());
                }
            }
            if (dataType != null) {
                if (!operand2.getValue().startsWith(LEFT_PARANTHESIS)) {
                    isNamespaceQualified = false;
                    String tempVal = null;
                    String[] values = operand2.getValue().split("\\.");
                    currentColoumnName = new CaseInsensitiveString(values[values.length - 1]);
                    if (operand2.getValue().equalsIgnoreCase(entityName) || propertyNames.get(currentColoumnName.getValue().toLowerCase()) != null) {
                        dataType = propertyTypeMap.get(currentColoumnName);
                        tempVal = AuthorizationExpressionParser.getColumnNameFromOuterEntity(serviceName, entityName, dataType, propertyNames, currentColoumnName, tempVal);
                        isNamespaceQualified = true;
                    } else if (fqSubSelectTable != null && operand2.getValue().equalsIgnoreCase(subSelectTable) || CSNUtil.getAllColumns(serviceName, subSelectTable).contains(currentColoumnName.getValue())) {
                        dataType = AuthorizationExpressionParser.getColumnDataTypeFromCSN(serviceName, subSelectTable, currentColoumnName);
                        tempVal = fqSubSelectTable + "." + currentColoumnName.getValue().toLowerCase();
                        isNamespaceQualified = true;
                    } else {
                        tempVal = operand2.getValue();
                    }
                    if (isHanaSql && !NULL.equals(tempVal)) {
                        if (tempVal.startsWith("'") && tempVal.endsWith("'")) {
                            tempVal = tempVal.substring(1, tempVal.length() - 1);
                        }
                        Operand operand = operand2 = isNamespaceQualified ? new Operand(tempVal).getOperandWithoutAlisCDS(SQLMapping.isPlainSqlMapping()) : new Operand(HANA_PARAM_PLACEHOLDER);
                        if (!isNamespaceQualified) {
                            infixParams.add(new InfixParam(currentColoumnPropertyName, tempVal, dataType, fqSubSelectTable));
                        }
                    } else {
                        operand2 = isNamespaceQualified ? new Operand(tempVal).getOperandWithoutAlisCDS(SQLMapping.isPlainSqlMapping()) : new Operand(AuthorizationExpressionParser.getTransformedRightOperand(dataType, tempVal));
                    }
                } else if (opr == Operator.IN) {
                    StringBuilder inClauseBuilder = new StringBuilder();
                    String[] inClauseTokens = AuthorizationExpressionParser.tokenizer(operand2.getValue());
                    for (int index = 0; index < inClauseTokens.length; ++index) {
                        String tempToken = inClauseTokens[index];
                        if (tempToken.charAt(0) == '\'' && tempToken.charAt(tempToken.length() - 1) != '\'' || tempToken.equals("'")) {
                            StringBuilder sb2 = new StringBuilder();
                            while (inClauseTokens[index].charAt(inClauseTokens[index].length() - 1) != '\'' || inClauseTokens[index].equals("'")) {
                                sb2.append(inClauseTokens[index]);
                                ++index;
                            }
                            sb2.append(inClauseTokens[index]);
                            tempToken = sb2.toString();
                        }
                        if (!(LEFT_PARANTHESIS.equals(tempToken) || COMMA.equals(tempToken) || RIGHT_PARANTHESIS.equals(tempToken))) {
                            if (isHanaSql) {
                                if (tempToken.charAt(0) == '\'' && tempToken.charAt(tempToken.length() - 1) == '\'') {
                                    tempToken = tempToken.substring(1, tempToken.length() - 1);
                                }
                                infixParams.add(new InfixParam(currentColoumnPropertyName, tempToken, dataType, fqSubSelectTable));
                                tempToken = HANA_PARAM_PLACEHOLDER;
                            } else {
                                tempToken = AuthorizationExpressionParser.getTransformedRightOperand(dataType, tempToken);
                            }
                        }
                        inClauseBuilder.append(tempToken);
                    }
                    operand2 = new Operand(inClauseBuilder.toString());
                }
            }
            stack.push(operand1.transformToInfixOperand(opr, operand2));
        }
        Operand result = null;
        StringBuilder str = new StringBuilder();
        if (fqSubSelectTable != null) {
            str = AuthorizationExpressionParser.generateSubSelectQuery(isHanaSql, fqSubSelectTable, stack, str);
        } else {
            result = (Operand)stack.pop();
        }
        if (isHanaSql) {
            return fqSubSelectTable != null ? new InfixSQL(str.toString(), infixParams) : new InfixSQL(result.getValue(), infixParams);
        }
        return fqSubSelectTable != null ? new InfixSQL(str.toString()) : new InfixSQL(result.getValue());
    }

    private static StringBuilder generateSubSelectQuery(boolean isHanaSql, String fqSubSelectTable, Stack<Operand> stack, StringBuilder str) {
        String operator = ((Operand)stack.elementAt(0)).getValue();
        if (operator.equalsIgnoreCase(NOT)) {
            operator = operator + SPACE + ((Operand)stack.elementAt(1)).getValue();
        }
        String whereList = null;
        String columnList = "";
        while (!stack.empty() && !stack.peek().getValue().equalsIgnoreCase(WHERE.trim())) {
            whereList = stack.pop().getValue();
        }
        while (!stack.empty() && !stack.peek().getValue().equals(FROM.trim())) {
            stack.pop();
        }
        stack.pop();
        while (!stack.empty() && !stack.peek().getValue().equals(SELECT.trim())) {
            String value = stack.pop().getValue();
            columnList = columnList + (!value.equalsIgnoreCase(COMMA) ? AuthorizationExpressionParser.getPersistenceName(fqSubSelectTable, value) : value);
        }
        if (!isHanaSql) {
            str.append(operator);
            str.append("( select  from ").append(SQLMapping.convertToUpperCaseIfRequired(fqSubSelectTable));
            str.append(LEFT_CURLY_PARANTHESIS).append(columnList).append(RIGHT_CURLY_PARANTHESIS);
            str.append(WHERE).append(SPACE).append(whereList).append(" )");
        } else {
            str.append(operator);
            str.append("( select ").append(columnList).append(FROM).append(fqSubSelectTable).append(WHERE).append(whereList).append(" )");
        }
        return str;
    }

    private static String getPersistenceName(String fqEntityName, String elementName) {
        String persistenceName = null;
        boolean isHdbcdsMode = CSNUtil.isHdbcdsMapping();
        if (isHdbcdsMode) {
            persistenceName = CSNUtil.getPersistenceName(fqEntityName, elementName);
        }
        if (persistenceName == null && elementName != null) {
            persistenceName = SQLMapping.convertToUpperCaseIfRequired(elementName);
        }
        return persistenceName + ALIAS + persistenceName;
    }

    private static String getColumnNameFromOuterEntity(String serviceName, String entityName, String dataType, Map<String, CaseInsensitiveString> propertyNames, CaseInsensitiveString currentColoumnName, String tempVal) {
        if (dataType != null) {
            tempVal = propertyNames.get(currentColoumnName.getValue().toLowerCase()).getValue();
            tempVal = SQLMapping.quoteIfRequired(ALIAS_Prefix + tempVal);
        }
        return tempVal;
    }

    private static String getColumnDataTypeFromCSN(String serviceName, String subSelectTable, CaseInsensitiveString currentColoumnName) {
        String cdsDataType = CSNUtil.getCDSDataType(subSelectTable, serviceName, currentColoumnName.getValue());
        String dataType = cdsDataType != null ? cdsDataType.substring(cdsDataType.indexOf(".") + 1) : null;
        return dataType;
    }

    private static String getSubSelectTable(String serviceName, Object token, String subSelectTable, Stack<Operand> stack) {
        if (((Operand)token).getValue().equalsIgnoreCase("where")) {
            subSelectTable = stack.peek().getValue();
            String[] tableNames = subSelectTable.split("\\.");
            subSelectTable = tableNames.length > 1 ? SQLMapping.quoteIfRequired(SQLMapping.replaceDotIfRequired(subSelectTable)) : SQLMapping.quoteIfRequired(SQLMapping.replaceDotIfRequired(serviceName + "." + subSelectTable));
        }
        return subSelectTable;
    }

    private static String getTransformedRightOperand(String dataType, String rightVal) {
        StringBuilder rightExp = new StringBuilder();
        if (dataType == null) {
            return null;
        }
        if (NULL.equalsIgnoreCase(rightVal)) {
            return NULL;
        }
        switch (dataType) {
            case "Edm.Guid": 
            case "Edm.String": {
                if ("\"\"".equals(rightVal)) {
                    rightExp.append("''");
                    break;
                }
                if (rightVal.charAt(0) != '\'' || rightVal.charAt(rightVal.length() - 1) != '\'') {
                    rightExp.append("'");
                    rightExp.append(rightVal);
                    rightExp.append("'");
                    break;
                }
                return rightVal;
            }
            default: {
                return rightVal;
            }
        }
        return rightExp.toString();
    }

    private static void processOperator(Operator op, Queue<Object> resultStack, Stack<Object> expStack) {
        while (!expStack.isEmpty() && op.precedence <= AuthorizationExpressionParser.Prec(expStack.peek())) {
            resultStack.add(expStack.pop());
        }
        expStack.push((Object)op);
    }

    static int Prec(Object token) {
        if (token instanceof Operator) {
            return ((Operator)((Object)token)).getPrecedence();
        }
        return -1;
    }

    private static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    private static boolean isContinsAlpha(String s) {
        return s != null && s.matches(".*[a-zA-Z]+.*");
    }
}

