/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.http;

import com.sap.cloud.security.xsuaa.http.HttpHeader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class HttpHeaders {
    public static final String AUTHORIZATION = "Authorization";
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String X_ZID = "X-zid";
    @Deprecated(forRemoval=true)
    public static final String X_ZONE_UUID = "x-zone_uuid";
    public static final String X_APP_TID = "x-app_tid";
    public static final String X_CLIENT_ID = "x-client_id";
    public static final String X_AZP = "x-azp";
    public static final String X_CLIENT_CERT = "x-client_cert";
    public static final String X_OSB_PLAN = "x-osb_plan";
    private final Set<HttpHeader> headers;

    public HttpHeaders(HttpHeader ... headers) {
        this(Arrays.asList(headers));
    }

    public HttpHeaders(Collection<HttpHeader> headers) {
        this.headers = new HashSet<HttpHeader>(headers);
    }

    public Set<HttpHeader> getHeaders() {
        return this.headers;
    }

    public HttpHeaders withHeader(String headerName, String value) {
        this.headers.add(new HttpHeader(headerName, value));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeaders that = (HttpHeaders)o;
        return Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.headers);
    }

    public String toString() {
        return "HttpHeaders: [ " + this.headers.stream().map(HttpHeader::toString).collect(Collectors.joining(", ")) + " ]";
    }
}

