/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet.response.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.sdk.cloudplatform.exception.StringParsingException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.serializer.GsonSerializer;
import com.sap.cloud.sdk.cloudplatform.util.StringConverter;
import java.lang.reflect.Type;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DateGsonSerializer
implements GsonSerializer<Date> {
    @Nonnull
    public JsonElement serialize(@Nullable Date date, @Nonnull Type typeOfSrc, @Nonnull JsonSerializationContext context) {
        String str = StringConverter.toString((Date)date);
        if (str == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(str);
    }

    @Nullable
    public Date deserialize(@Nonnull JsonElement json, @Nonnull Type typeOfT, @Nonnull JsonDeserializationContext context) {
        try {
            return StringConverter.toDate((String)json.getAsString());
        }
        catch (StringParsingException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

