/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.sap.cloud.sdk.cloudplatform.security.principal.BasicCredentialsPrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.OAuth2AuthTokenPrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.OidcAuthTokenPrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalFacade;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import io.vavr.control.Try;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class DefaultPrincipalFacade
implements PrincipalFacade {
    private static final List<PrincipalExtractor> DEFAULT_PRINCIPAL_EXTRACTORS = Arrays.asList(new OAuth2AuthTokenPrincipalExtractor(), new OidcAuthTokenPrincipalExtractor(), new BasicCredentialsPrincipalExtractor());
    private final List<PrincipalExtractor> principalExtractors;

    public DefaultPrincipalFacade() {
        this(DEFAULT_PRINCIPAL_EXTRACTORS);
    }

    @Override
    @Nonnull
    public Try<Principal> tryGetCurrentPrincipal() {
        Try principalFromThreadContextTry = ThreadContextAccessor.tryGetCurrentContext().flatMap(c -> c.getPropertyValue(PrincipalThreadContextListener.PROPERTY_PRINCIPAL));
        if (principalFromThreadContextTry.isSuccess()) {
            return principalFromThreadContextTry;
        }
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        throwables.add(principalFromThreadContextTry.getCause());
        return this.principalExtractors.stream().map(PrincipalExtractor::tryGetCurrentPrincipal).filter(principalTry -> principalTry.onFailure(throwables::add).isSuccess()).findFirst().orElseGet(() -> this.createFallbackException(throwables));
    }

    private Try<Principal> createFallbackException(@Nonnull List<? extends Throwable> throwables) {
        PrincipalAccessException resultingException = new PrincipalAccessException("Could not read a principal from thread context, JWT, nor Basic Auth header.");
        throwables.forEach(resultingException::addSuppressed);
        return Try.failure((Throwable)resultingException);
    }

    @Nullable
    <T> T executeWithPrincipal(@Nonnull Principal principal, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        return (T)ThreadContextExecutor.fromCurrentOrNewContext().withListeners(new ThreadContextListener[]{new PrincipalThreadContextListener(principal)}).execute(callable);
    }

    @Generated
    DefaultPrincipalFacade(List<PrincipalExtractor> principalExtractors) {
        this.principalExtractors = principalExtractors;
    }
}

