/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import com.sap.cloud.sdk.cloudplatform.util.StringUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class BearerCredentials
implements Credentials {
    @Nonnull
    private static final String BEARER_PREFIX = "Bearer ";
    @Nonnull
    private final String token;
    @Nonnull
    private final String httpHeaderValue;

    public BearerCredentials(@Nonnull String token) {
        String trimmedToken = token.trim();
        this.token = StringUtils.startsWithIgnoreCase((String)trimmedToken, (String)BEARER_PREFIX) ? trimmedToken.substring(BEARER_PREFIX.length()).trim() : trimmedToken;
        this.httpHeaderValue = BEARER_PREFIX + this.token;
    }

    @Nonnull
    public String toString() {
        return "BearerCredentials(token=(hidden))";
    }

    @Nonnull
    @Generated
    public String getToken() {
        return this.token;
    }

    @Nonnull
    @Generated
    public String getHttpHeaderValue() {
        return this.httpHeaderValue;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BearerCredentials)) {
            return false;
        }
        BearerCredentials other = (BearerCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$httpHeaderValue = this.getHttpHeaderValue();
        String other$httpHeaderValue = other.getHttpHeaderValue();
        return !(this$httpHeaderValue == null ? other$httpHeaderValue != null : !this$httpHeaderValue.equals(other$httpHeaderValue));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof BearerCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $httpHeaderValue = this.getHttpHeaderValue();
        result = result * 59 + ($httpHeaderValue == null ? 43 : $httpHeaderValue.hashCode());
        return result;
    }
}

