/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.security.BasicAuthHeaderEncoder;
import com.sap.cloud.sdk.cloudplatform.security.Credentials;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class BasicCredentials
implements Credentials {
    @Nonnull
    private static final String BASIC_PREFIX = "Basic ";
    @Nonnull
    private final String username;
    @Nonnull
    private final String password;
    @Nonnull
    private final String httpHeaderValue;

    public BasicCredentials(@Nonnull String username, @Nonnull String password) {
        this.username = username;
        this.password = password;
        this.httpHeaderValue = BASIC_PREFIX + BasicAuthHeaderEncoder.encodeUserPasswordBase64(username, password);
    }

    @Nonnull
    public String toString() {
        return "BasicCredentials(username=" + this.username + ", password=(hidden))";
    }

    @Nonnull
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Nonnull
    @Generated
    public String getHttpHeaderValue() {
        return this.httpHeaderValue;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicCredentials)) {
            return false;
        }
        BasicCredentials other = (BasicCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$httpHeaderValue = this.getHttpHeaderValue();
        String other$httpHeaderValue = other.getHttpHeaderValue();
        return !(this$httpHeaderValue == null ? other$httpHeaderValue != null : !this$httpHeaderValue.equals(other$httpHeaderValue));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof BasicCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $httpHeaderValue = this.getHttpHeaderValue();
        result = result * 59 + ($httpHeaderValue == null ? 43 : $httpHeaderValue.hashCode());
        return result;
    }
}

