/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.exception.AuthTokenAccessException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

@FunctionalInterface
interface AuthTokenDecoder {
    @Nonnull
    public AuthToken decode(@Nonnull String var1) throws AuthTokenAccessException;

    @Nonnull
    default public Try<AuthToken> decode(@Nonnull RequestHeaderContainer headers) {
        List headerValues = headers.getHeaderValues("Authorization");
        if (headerValues.isEmpty()) {
            String message = "Failed to decode JWT bearer: no 'Authorization' header present in request.";
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to decode JWT bearer: no 'Authorization' header present in request."));
        }
        if (headerValues.size() > 1) {
            String message = "Failed to decode JWT bearer: multiple 'Authorization' headers present in request.";
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to decode JWT bearer: multiple 'Authorization' headers present in request."));
        }
        String authorizationValue = (String)headerValues.stream().findFirst().get();
        String bearerPrefix = "bearer ";
        if (!authorizationValue.toLowerCase(Locale.ENGLISH).startsWith("bearer ")) {
            String message = "Failed to decode JWT bearer: no JWT bearer present in 'Authorization' header of request.";
            return Try.failure((Throwable)new AuthTokenAccessException("Failed to decode JWT bearer: no JWT bearer present in 'Authorization' header of request."));
        }
        String tokenValue = authorizationValue.substring("bearer ".length());
        return Try.of((CheckedFunction0 & Serializable)() -> this.decode(tokenValue));
    }
}

