/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpEntityUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpEntityUtil.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getResponseBody(@Nonnull HttpResponse response) throws IOException, ParseException {
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity == null) {
            return null;
        }
        try {
            Object[] encodingHeaders = response.getHeaders("Content-Encoding");
            if (encodingHeaders.length > 1) {
                log.warn("Multiple headers for Content-Encoding: " + Arrays.toString(encodingHeaders) + ".");
            }
            if (encodingHeaders.length >= 1 && encodingHeaders[0].getValue().equalsIgnoreCase("gzip")) {
                responseEntity = new GzipDecompressingEntity(response.getEntity());
            }
            String string = EntityUtils.toString((HttpEntity)responseEntity, (Charset)DEFAULT_CHARSET);
            return string;
        }
        finally {
            try {
                EntityUtils.consume((HttpEntity)responseEntity);
            }
            catch (IOException e) {
                log.warn("Failed to consume HTTP response entity.", (Throwable)e);
            }
        }
    }
}

