/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.cache;

import com.sap.cloud.sdk.cloudplatform.cache.CacheRuntimeException;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public final class CacheUtil {
    private CacheUtil() {
    }

    @Nonnull
    public static <K, V> Function<K, V> wrapCallableAsFunction(@Nonnull Callable<V> callable) {
        return ignoreKey -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new CacheRuntimeException(e);
            }
        };
    }

    @Nonnull
    public static <K, V> Function<K, V> wrapSupplierAsFunction(@Nonnull Supplier<V> supplier) {
        return ignoreKey -> supplier.get();
    }
}

