/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserFacade;
import com.sap.cloud.sdk.cloudplatform.security.user.UserRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import io.vavr.control.Try;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public abstract class AbstractUserFacade
implements UserFacade {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractUserFacade.class);
    private static final String VARIABLE_USE_MOCKED_USER = "USE_MOCKED_USER";

    @Nonnull
    protected abstract User newMockedUser();

    @Nonnull
    public Optional<User> getMockedUser() {
        String env = System.getenv(VARIABLE_USE_MOCKED_USER);
        if (Boolean.valueOf(env).booleanValue()) {
            logger.error("Using a mocked user with blank user name and no authorizations since environment variable 'USE_MOCKED_USER' is set to 'true'. SECURITY WARNING: This variable must never be used in productive environments!");
            return Optional.of(this.newMockedUser());
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public User getCurrentUser() throws UserNotAuthenticatedException, UserAccessException {
        Optional<User> currentUser = this.getCurrentUserIfAuthenticated();
        if (!currentUser.isPresent()) {
            throw new UserNotAuthenticatedException("Failed to get current user: user not authenticated. For details on the security configuration, please refer to the SAP Cloud Platform documentation. Tutorials on the configuration are available at 'https://help.sap.com/viewer/p/SAP_CLOUD_SDK'.");
        }
        return currentUser.get();
    }

    @Override
    @Nonnull
    public Optional<User> getCurrentUserIfAuthenticated() throws UserAccessException {
        Optional property;
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (!requestContext.isPresent()) {
            throw new UserAccessException("Failed to get current user: no " + RequestContext.class.getSimpleName() + " available. Have you correctly configured a " + RequestContextServletFilter.class.getSimpleName() + " or have you wrapped your logic in a " + RequestContextExecutor.class.getSimpleName() + " when executing background tasks that are not triggered by a request?");
        }
        try {
            property = ((RequestContext)requestContext.get()).getProperty(UserRequestContextListener.PROPERTY_USER);
        }
        catch (RequestContextPropertyException e) {
            throw new UserAccessException("Failed to get current user: failed to get " + RequestContext.class.getSimpleName() + " property.", e);
        }
        if (!property.isPresent()) {
            throw new UserAccessException("Failed to get current tenant: " + RequestContext.class.getSimpleName() + " property '" + UserRequestContextListener.PROPERTY_USER + "' not initialized. Have you correctly configured a " + UserRequestContextListener.class.getSimpleName() + " in the relevant " + RequestContextServletFilter.class.getSimpleName() + " or " + RequestContextExecutor.class.getSimpleName() + "?");
        }
        Exception exception = ((Property)property.get()).getException();
        if (exception != null) {
            throw new UserAccessException("Failed to get current user.", exception);
        }
        User user = (User)((Property)property.get()).getValue();
        return Optional.ofNullable(user);
    }

    @Override
    @Nonnull
    public Try<User> tryGetCurrentUser() {
        return Try.of(this::getCurrentUser);
    }
}

