/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.servlet;

import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class HttpCachingHeaderFilter
implements Filter {
    private static final Logger logger = CloudLoggerFactory.getLogger(HttpCachingHeaderFilter.class);
    protected static final Set<String> CACHEABLE_CONTENT_TYPES = Sets.newHashSet((Object[])new String[]{"text/css", "text/javascript", "image/webp", "image/png", "image/jpeg", "image/gif", "image/jpg", "image/svg+xml", "application/javascript", "application/xml", "application/css", "application/x-font-woff", "application/x-font-ttf"});

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletResponse resp = (HttpServletResponse)response;
            String requestPath = ((HttpServletRequest)request).getRequestURI();
            this.setResponseHeadersByRequestPath(requestPath, resp);
        }
        chain.doFilter(request, response);
    }

    private void setResponseHeadersByRequestPath(String requestPath, HttpServletResponse resp) {
        if (requestPath.contains("sap-ui-cachebuster-info.json")) {
            if (logger.isDebugEnabled()) {
                logger.debug("Not adding caching headers for request path '{}'.", (Object)requestPath);
            }
        } else {
            String contentType = resp.getContentType();
            if (logger.isDebugEnabled()) {
                logger.debug("Adding caching headers for request path '{}' and content type '{}'.", (Object)requestPath, (Object)contentType);
            }
            if (contentType != null && CACHEABLE_CONTENT_TYPES.contains(contentType.toLowerCase(Locale.ENGLISH))) {
                ZonedDateTime dt = ZonedDateTime.now().plusDays(1L);
                resp.setDateHeader("Expires", dt.toInstant().toEpochMilli());
            } else {
                resp.setHeader("Cache-Control", "no-cache, no-store");
                resp.setHeader("Expires", "0");
            }
        }
    }
}

