/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.secret;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStore;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStoreFacade;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.KeyStoreAccessException;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.KeyStoreNotFoundException;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.SecretStoreAccessException;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.SecretStoreNotFoundException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import java.security.KeyStore;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SecretStoreAccessor {
    @Nullable
    private static SecretStoreFacade secretStoreFacade = (SecretStoreFacade)FacadeLocator.getFacade(SecretStoreFacade.class);

    private static SecretStoreFacade facade() throws ShouldNotHappenException {
        if (secretStoreFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform while accessing secret store information. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SAP Cloud Platform Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SAP Cloud Platform Neo. Within tests, make sure to declare a dependency on com.sap.cloud.s4hana:testutil, add 'private static final MockUtil mockUtil = new MockUtil();' to your test class, and invoke 'mockUtil.mockDefaults();' before running the tests.");
        }
        return secretStoreFacade;
    }

    public static void setSecretStoreFacade(@Nonnull SecretStoreFacade secretStoreFacade) {
        SecretStoreAccessor.secretStoreFacade = secretStoreFacade;
    }

    @Nonnull
    public static SecretStore getSecretStore(String name) throws SecretStoreNotFoundException, SecretStoreAccessException {
        return SecretStoreAccessor.facade().getSecretStore(name);
    }

    @Nonnull
    public static Optional<SecretStore> getSecretStoreIfPresent(String name) throws SecretStoreAccessException {
        return SecretStoreAccessor.facade().getSecretStoreIfPresent(name);
    }

    @Nonnull
    public static KeyStore getKeyStore(String name, SecretStore password) throws KeyStoreNotFoundException, KeyStoreAccessException {
        return SecretStoreAccessor.facade().getKeyStore(name, password);
    }

    @Nonnull
    public static Optional<KeyStore> getKeyStoreIfPresent(String name, SecretStore password) throws KeyStoreAccessException {
        return SecretStoreAccessor.facade().getKeyStoreIfPresent(name, password);
    }

    @Nullable
    public static SecretStoreFacade getSecretStoreFacade() {
        return secretStoreFacade;
    }
}

