/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessException;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalFacade;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrincipalAccessor {
    @Nullable
    private static PrincipalFacade principalFacade = (PrincipalFacade)FacadeLocator.getFacade(PrincipalFacade.class);

    @Nonnull
    static PrincipalFacade facade() throws ShouldNotHappenException {
        if (principalFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform while accessing principal information. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SAP Cloud Platform Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SAP Cloud Platform Neo. Within tests, make sure to declare a dependency on com.sap.cloud.s4hana:testutil, add 'private static final MockUtil mockUtil = new MockUtil();' to your test class, and invoke 'mockUtil.mockDefaults();' before running the tests.");
        }
        return principalFacade;
    }

    public static void setPrincipalFacade(@Nonnull PrincipalFacade principalFacade) {
        PrincipalAccessor.principalFacade = principalFacade;
    }

    @Nonnull
    public static Principal getCurrentPrincipal() throws PrincipalAccessException {
        return PrincipalAccessor.facade().getCurrentPrincipal();
    }
}

