/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.servlet;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.servlet.HttpCachingHeaderWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class HttpCachingHeaderFilter
implements Filter {
    private static final Logger logger = CloudLoggerFactory.getLogger(HttpCachingHeaderFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse resp = (HttpServletResponse)response;
        String requestPath = ((HttpServletRequest)request).getRequestURI();
        if (requestPath.contains("sap-ui-cachebuster-info.json")) {
            if (logger.isDebugEnabled()) {
                logger.debug("Not adding caching headers for request path \"" + requestPath + "\".");
            }
            chain.doFilter(request, response);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding caching headers for request path \"" + requestPath + "\".");
            }
            chain.doFilter(request, (ServletResponse)new HttpCachingHeaderWrapper(resp));
        }
    }

    public void destroy() {
    }
}

