/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.secret;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStore;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStoreFacade;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.KeyStoreException;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.SecretStoreException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import java.security.KeyStore;
import javax.annotation.Nullable;

public class SecretStoreAccessor {
    @Nullable
    private static SecretStoreFacade secretStoreFacade = (SecretStoreFacade)FacadeLocator.getFacade(SecretStoreFacade.class);

    private static SecretStoreFacade facade() throws ShouldNotHappenException {
        SecretStoreFacade secretStoreFacade = SecretStoreAccessor.secretStoreFacade;
        if (secretStoreFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform while accessing secret store information. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SCP Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SCP Neo. Within tests, make sure to declare \"private static final MockUtil mockUtil = new MockUtil()\" in your test class and invoke \"mockUtil.mockDefaults()\" before running the tests.");
        }
        return secretStoreFacade;
    }

    public static void setSecretStoreFacade(SecretStoreFacade secretStoreFacade) {
        SecretStoreAccessor.secretStoreFacade = secretStoreFacade;
    }

    public static SecretStore getSecretStore(String name) throws SecretStoreException {
        return SecretStoreAccessor.facade().getSecretStore(name);
    }

    public static KeyStore getKeyStore(String name, SecretStore password) throws KeyStoreException {
        return SecretStoreAccessor.facade().getKeyStore(name, password);
    }

    @Nullable
    public static SecretStoreFacade getSecretStoreFacade() {
        return secretStoreFacade;
    }
}

