/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.google.common.base.Charsets;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthHeaderEncoder {
    public static String encodeUserPasswordBase64(@NonNull String username, @NonNull String password) {
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        return new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes(Charsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String encodeUserPasswordBase64(@NonNull BasicCredentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        return BasicAuthHeaderEncoder.encodeUserPasswordBase64(credentials.getUsername(), credentials.getPassword());
    }
}

