/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding.api;

import com.sap.cloud.environment.servicebinding.api.ServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.ServiceBindingMerger;
import com.sap.cloud.environment.servicebinding.api.SimpleServiceBindingCache;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultServiceBindingAccessor {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(DefaultServiceBindingAccessor.class);
    @Nonnull
    private static ServiceBindingAccessor instance = DefaultServiceBindingAccessor.newDefaultInstance();

    private DefaultServiceBindingAccessor() {
        throw new IllegalStateException("This utility class must not be instantiated.");
    }

    @Nonnull
    public static ServiceBindingAccessor getInstance() {
        return instance;
    }

    public static void setInstance(@Nullable ServiceBindingAccessor accessor) {
        if (accessor != null) {
            logger.debug("Setting instance to {}.", (Object)accessor.getClass().getName());
            instance = accessor;
        } else {
            logger.debug("Resetting instance.");
            instance = DefaultServiceBindingAccessor.newDefaultInstance();
        }
    }

    @Nonnull
    private static ServiceBindingAccessor newDefaultInstance() {
        List<ServiceBindingAccessor> defaultAccessors = ServiceBindingAccessor.getInstancesViaServiceLoader();
        if (logger.isDebugEnabled()) {
            String classNames = defaultAccessors.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining(", "));
            logger.debug("Following implementations of {} will be used for the {}: {}.", new Object[]{ServiceBindingAccessor.class.getSimpleName(), DefaultServiceBindingAccessor.class.getSimpleName(), classNames});
        }
        ServiceBindingMerger bindingMerger = new ServiceBindingMerger(defaultAccessors, ServiceBindingMerger.KEEP_EVERYTHING);
        return new SimpleServiceBindingCache(bindingMerger);
    }
}

