/*
 * Decompiled with CFR 0.152.
 */
package com.sanctionco.thunder.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.StringJoiner;

public class Email {
    private final String address;
    private final boolean verified;
    private final String verificationToken;

    @JsonCreator
    public Email(@JsonProperty(value="address") String address, @JsonProperty(value="verified") boolean verified, @JsonProperty(value="verificationToken") String verificationToken) {
        this.address = address;
        this.verified = verified;
        this.verificationToken = verificationToken;
    }

    public String getAddress() {
        return this.address;
    }

    public String getVerificationToken() {
        return this.verificationToken;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public Email verifiedCopy() {
        return new Email(this.address, true, this.verificationToken);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (!(object instanceof Email)) {
            return false;
        }
        Email other = (Email)object;
        return Objects.equals(this.address, other.address) && Objects.equals(this.verified, other.verified) && Objects.equals(this.verificationToken, other.verificationToken);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.verified, this.verificationToken);
    }

    public String toString() {
        return new StringJoiner(", ", "Email [", "]").add(String.format("address=%s", this.address)).add(String.format("verified=%b", this.verified)).add(String.format("verificationToken=%s", this.verificationToken)).toString();
    }

    public static Email unverified(String address) {
        return new Email(address, false, null);
    }
}

