package com.samebug.notifier.log4j;

import com.samebug.notifier.core.IConfiguration;

import java.net.URL;
import java.util.UUID;

public class Config implements IConfiguration {
    public final UUID appKey;
    public final String version;
    public final URL recorderURL;
    public final boolean debug;
    public final UUID developerKey;
    public final URL UIURL;
    public final int helpMode;
    public final int queueCapacity;

    public UUID getAppKey() {
        return appKey;
    }

    public String getVersion() {
        return version;
    }

    public URL getRecorderURL() {
        return recorderURL;
    }

    public boolean getDebug() {
        return debug;
    }

    public UUID getDeveloperKey() {
        return developerKey;
    }

    public URL getUIURL() {
        return UIURL;
    }

    public int getHelpMode() {
        return helpMode;
    }

    public int getQueueCapacity() {
        return queueCapacity;
    }

    public Config(UUID appKey, String version, URL recorderURL, boolean debug, UUID developerKey, URL uiurl, int helpMode, int queueCapacity) {
        this.appKey = appKey;
        this.version = version;
        this.recorderURL = recorderURL;
        this.debug = debug;
        this.developerKey = developerKey;
        UIURL = uiurl;
        this.helpMode = helpMode;
        this.queueCapacity = queueCapacity;
    }
}
