/*
 * Created on 2013.09.02.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.SamebugAsyncNotifier;
import com.samebug.notifier.core.exceptions.BadServerAddress;
import com.samebug.notifier.core.exceptions.UnsupportedUTF8;
import com.samebug.notifier.core.exceptions.UrlEncodingError;

import java.util.Date;

public class SamebugAppender extends AppenderBase<ILoggingEvent> {
    private final SamebugAsyncNotifier notifier;

    /**
     * Constructs a new appender.
     */
    public SamebugAppender() {
        this(ConfigurationFactory.fromDefault());
    }

    public SamebugAppender(final IConfiguration config) {
        super();
        notifier = new SamebugAsyncNotifier(config);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void append(final ILoggingEvent event) {
        if (event != null && event.getThrowableProxy() != null) {
            notifier.notify(event.getMessage(), new LogbackThrowableProxy(event.getThrowableProxy()), new Date());
        }
    }
}