/*
 * Created on 2013.09.03.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier.logback;

import ch.qos.logback.classic.spi.IThrowableProxy;
import com.samebug.notifier.core.proxy.StackTraceProxy;
import com.samebug.notifier.core.proxy.ThrowableProxy;

final class LogbackThrowableProxy implements ThrowableProxy {

    private final IThrowableProxy throwable;

    public LogbackThrowableProxy(final IThrowableProxy throwable) {
        this.throwable = throwable;
    }

    public String getMessage() {
        return this.throwable.getMessage();
    }

    public ThrowableProxy getCause() {
        return this.throwable.getCause() == null ? null : new LogbackThrowableProxy(this.throwable.getCause());
    }

    public StackTraceProxy getStackTrace() {
        return new LogbackStackTraceProxy(this.throwable.getStackTraceElementProxyArray());
    }

    public int getCommonFramesWithCause() {
        return this.throwable.getCause() == null ? 0 : this.throwable.getCause().getCommonFrames();
    }

    public String getClassName() {
        return this.throwable.getClassName();
    }

}
