/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier.log4j;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.IReporter;
import com.samebug.notifier.StreamReporter;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.IResponse;
import com.samebug.notifier.core.SamebugNotifier;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.exceptions.RecorderError;
import java.util.Date;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class SamebugAppender
extends AppenderSkeleton {
    private final IReporter reporter;
    private final SamebugNotifier notifier;

    public SamebugAppender() {
        this(ConfigurationFactory.fromDefault());
    }

    public SamebugAppender(IConfiguration config) {
        this.reporter = new StreamReporter(config);
        this.notifier = new SamebugNotifier(config);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent event) {
        if (event.getThrowableInformation() != null) {
            try {
                IResponse response = this.notifier.notify(event.getMessage() == null ? null : String.valueOf(event.getMessage()), event.getThrowableInformation().getThrowable(), new Date());
                this.reporter.handleResponse(response);
            }
            catch (RecorderError e) {
                this.reporter.handleRecorderError(e);
            }
            catch (NotifierException e) {
                this.reporter.handleNotifierException(e);
            }
        }
    }
}

