package com.samebug.notifier.jboss;

import java.util.Date;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.IReporter;
import com.samebug.notifier.StreamReporter;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.IResponse;
import com.samebug.notifier.core.SamebugNotifier;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.exceptions.RecorderError;

public class SamebugHandler extends Handler {

    private SamebugNotifier notifier;
    private Properties properties;
    private IReporter reporter;

    public SamebugHandler() {
        super();
        notifier = null;
        properties = new Properties();
        reporter = null;
    }

    public void publish(LogRecord record) {
        if (notifier == null) {
            configure();
        }
        if (record.getThrown() != null) {
            try {
                IResponse resp = notifier.notify(record.getMessage(), record.getThrown(), new Date());
                reporter.handleResponse(resp);
            } catch (final RecorderError e) {
                reporter.handleRecorderError(e);
            } catch (final NotifierException e) {
                reporter.handleNotifierException(e);
            }
        }
    }

    public void flush() {
        // TODO: buffer
    }

    public void close() throws SecurityException {
        // TODO: close connection
    }

    public void setAppKey(String appKey) {
        properties.put(ConfigurationFactory.K_APP_KEY, appKey);
    }

    public void setVersion(String version) {
        properties.put(ConfigurationFactory.K_VERSION, version);
    }

    public void setServerURL(String recorderURL) {
        properties.put(ConfigurationFactory.K_RECORDER_URL, recorderURL);
    }

    public void setDebug(String debug) {
        properties.put(ConfigurationFactory.K_DEBUG, debug);
    }

    public void setUIURL(String uiURL) {
        properties.put(ConfigurationFactory.K_UI_URL, uiURL);
    }

    public void setHelpMode(String helpMode) {
        properties.put(ConfigurationFactory.K_HELP_MODE, helpMode);
    }

    private void configure() {
        IConfiguration config = ConfigurationFactory.fromProperties(properties);
        notifier = new SamebugNotifier(config);
        reporter = new StreamReporter(config);
    }
}
