/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.Configuration;
import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.exceptions.BadAppKey;
import com.samebug.notifier.exceptions.BadServerAddress;
import com.samebug.notifier.exceptions.MultipleConfigFileException;
import com.samebug.notifier.exceptions.NoConfigFileException;
import com.samebug.notifier.exceptions.NotifierException;
import com.samebug.notifier.exceptions.RecorderError;

public class SamebugUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final SamebugNotifier notifier;

    public SamebugUncaughtExceptionHandler() throws NoConfigFileException, MultipleConfigFileException, BadAppKey, BadServerAddress {
        this.notifier = new SamebugNotifier();
    }

    public SamebugUncaughtExceptionHandler(String applicationKey) {
        this.notifier = new SamebugNotifier(applicationKey);
    }

    public SamebugUncaughtExceptionHandler(Configuration config) {
        this.notifier = new SamebugNotifier(config);
    }

    public void uncaughtException(Thread t, Throwable e) {
        try {
            this.notifier.notify("Uncaught exception", e);
        }
        catch (RecorderError re) {
            System.err.println("Failed to record an error to Samebug. Server responsed:\n" + re.getCode() + ": " + re.getMessage());
        }
        catch (NotifierException ne) {
            System.err.println("Failed to record an error to Samebug (code " + ne.getErrorCode() + "): " + ne.getMessage() + "\nCause:");
            ne.printStackTrace();
        }
    }
}

