package com.samebug.notifier.jul;

import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.exceptions.NotifierException;

public class SamebugHandler extends Handler {

    private final SamebugNotifier notifier;

    public SamebugHandler() {
        super();
        notifier = new SamebugNotifier();
    }

    public void publish(LogRecord record) {
        if (record.getThrown() != null && record.getLevel() == Level.SEVERE) {
            try {
                notifier.notify(record.getMessage(), record.getThrown(), new Date());
            } catch (final NotifierException e) {
                System.err.println("Error in samebug notifier (code " + e.getErrorCode() + "): " + e.getMessage());
                if (notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
            } catch (final RuntimeException e) {
                if (notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
                throw e;
            }
        }
    }

    public void flush() {
        // TODO: buffer
    }

    public void close() throws SecurityException {
        // TODO: close connection
    }
}