package com.samebug.notifier.jboss;

import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

import com.samebug.notifier.Configuration;
import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.exceptions.NotifierException;

public class SamebugHandler extends Handler {

    private SamebugNotifier notifier;

    private String appKey;
    private String version;
    private String serverURL;
    private String debug;

    public SamebugHandler() {
        super();
        notifier = null;
        appKey = null;
        version = null;
        serverURL = Configuration.DEFAULT_SERVER;
        debug = Configuration.DEFAULT_DEBUG;
    }

    public void publish(LogRecord record) {
        if (notifier == null) {
            configure();
        }
        if (record.getThrown() != null) {
            try {
                notifier.notify(record.getMessage(), record.getThrown(), new Date());
            } catch (final NotifierException e) {
                System.err.println("Error in samebug notifier (code " + e.getErrorCode() + "): " + e.getMessage());
                if (notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
            } catch (final RuntimeException e) {
                if (notifier.getConfiguration().getDebug()) {
                    e.printStackTrace(System.err);
                }
                throw e;
            }
        }
    }

    public void flush() {
        // TODO: buffer
    }

    public void close() throws SecurityException {
        // TODO: close connection
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    private void configure() {
        Configuration conf = new Configuration(appKey);
        conf.setVersion(version);
        conf.setServer(serverURL);
        conf.setDebug(debug);
        notifier = new SamebugNotifier(conf);
    }
}