/*
 * Created on 2013.09.17.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 */

package com.samebug.notifier.servlet;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import com.samebug.notifier.SamebugNotifier;
import com.samebug.notifier.exceptions.NotifierException;

public class SamebugFilter implements Filter {
    private SamebugNotifier notifier;

    public void init(final FilterConfig config) throws ServletException {
        // TODO: handle filter config parameters in the same manner as system
        // properties
        final String applicationKey = config.getInitParameter("samebug.key");
        if (applicationKey != null) {
            notifier = new SamebugNotifier(applicationKey);
        } else {
            notifier = new SamebugNotifier();
        }
    }

    private void notify(final ServletRequest request, final Throwable e) throws NotifierException {
        if (request instanceof HttpServletRequest) {
            final HttpServletRequest hr = (HttpServletRequest) request;
            final StringBuffer url = hr.getRequestURL();
            final String qs = hr.getQueryString();

            final StringBuilder sb = new StringBuilder();
            sb.append("Unhandled exception at ").append(url).append(" : ");
            if (qs != null) {
                sb.append("?").append(qs);
            }
            notifier.notify(sb.toString(), e);
        } else {
            notifier.notify("Unhandled exception", e);
        }
    }

    public void destroy() {
        // SKIP
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        try {
            try {
                chain.doFilter(request, response);
            } catch (final IOException e) {
                notify(request, e);
                throw e;
            } catch (final ServletException e) {
                notify(request, e);
                throw e;
            } catch (final RuntimeException e) {
                notify(request, e);
                throw e;
            } catch (final Error e) {
                notify(request, e);
                throw e;
            }
        } catch (final NotifierException e) {
            if (notifier.getConfiguration().getDebug()) {
                e.printStackTrace(System.err);
            }
        }
    }
}
