package com.samebug.notifier;

import java.io.Writer;
import java.util.Date;

import com.samebug.notifier.encoder.ContentEncoder;
import com.samebug.notifier.exceptions.JsonEncodingException;
import com.samebug.notifier.proxy.ThrowableProxy;

/**
 * Abstraction layer for serializing a crash to JSON.
 * 
 * @author poroszd
 * 
 */
class Encoder {
    private final Configuration config;
    private final ContentEncoder impl;

    /**
     * Creates an Encoder instance with the settings defined in
     * <code>config</code>, which writes the output to <code>writer</code>
     */
    public Encoder(final Configuration config, final Writer writer) {
        this.config = config;
        this.impl = new ContentEncoder(writer);
    }

    /**
     * Encode a crash to JSON
     */
    public void encode(final String message, final ThrowableProxy throwableProxy, final Date timestamp) throws JsonEncodingException {
        impl.startObject();
        impl.writeField("version", config.getVersion());
        impl.writeField("timestamp", timestamp);
        impl.writeField("message", message);
        impl.writeField("exception", throwableProxy);
        impl.endObject();
    }
}
