/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.plugins;

import android.support.annotation.NonNull;
import com.google.android.libraries.mediaframework.layeredvideo.SimpleVideoPlayer;
import com.sambatech.player.SambaPlayer;
import com.sambatech.player.plugins.Captions;
import com.sambatech.player.plugins.ImaWrapper;
import com.sambatech.player.plugins.Plugin;
import com.sambatech.player.plugins.Tracking;

public class PluginManager
implements Plugin {
    private static PluginManager instance = new PluginManager();
    private Plugin[] plugins;
    private SambaPlayer player;
    private int pluginsLoaded;
    private boolean isLoaded;
    private boolean pendingPlay;

    private PluginManager() {
    }

    public static PluginManager getInstance() {
        return instance;
    }

    @Override
    public void onLoad(@NonNull SambaPlayer player) {
        this.player = player;
        this.pluginsLoaded = 0;
        for (Plugin plugin : this.plugins = new Plugin[]{new ImaWrapper(), new Tracking(), new Captions()}) {
            plugin.onLoad(player);
        }
    }

    @Override
    public void onInternalPlayerCreated(@NonNull SimpleVideoPlayer internalPlayer) {
        for (Plugin plugin : this.plugins) {
            plugin.onInternalPlayerCreated(internalPlayer);
        }
    }

    @Override
    public void onDestroy() {
        if (this.plugins == null) {
            return;
        }
        for (Plugin plugin : this.plugins) {
            plugin.onDestroy();
        }
        this.plugins = null;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setPendingPlay(boolean value) {
        this.pendingPlay = value;
    }

    public Plugin getPlugin(Class PluginRef) {
        for (Plugin plugin : this.plugins) {
            if (plugin.getClass() != PluginRef) continue;
            return plugin;
        }
        return null;
    }

    void notifyPluginLoaded(Plugin plugin) {
        if (++this.pluginsLoaded >= this.plugins.length) {
            this.isLoaded = true;
            if (this.pendingPlay) {
                this.pendingPlay = false;
                this.player.play();
            }
        }
    }
}

