/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player;

import android.app.Activity;
import android.app.MediaRouteButton;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.Status;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.google.android.libraries.mediaframework.exoplayerextensions.UnsupportedDrmException;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.layeredvideo.PlaybackControlLayer;
import com.google.android.libraries.mediaframework.layeredvideo.SimpleVideoPlayer;
import com.sambatech.player.R;
import com.sambatech.player.adapter.CaptionsAdapter;
import com.sambatech.player.adapter.OutputAdapter;
import com.sambatech.player.cast.CastDRM;
import com.sambatech.player.cast.CastObject;
import com.sambatech.player.cast.CastOptionsProvider;
import com.sambatech.player.cast.CastQuery;
import com.sambatech.player.cast.SambaCast;
import com.sambatech.player.event.SambaCastListener;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.model.SambaPlayerError;
import com.sambatech.player.plugins.Captions;
import com.sambatech.player.plugins.PluginManager;
import com.sambatech.player.utils.Helpers;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class SambaPlayer
extends FrameLayout {
    private final ExoplayerWrapper.PlaybackListener playbackListener = new ExoplayerWrapper.PlaybackListener(){

        public void onStateChanged(boolean playWhenReady, int playbackState) {
            Log.i((String)"SambaPlayer", (String)("state: " + playWhenReady + " " + playbackState + "; playing: " + SambaPlayer.this.isPlaying()));
            switch (playbackState) {
                case 4: {
                    if (playWhenReady) {
                        if (!SambaPlayer.this._hasStarted) {
                            SambaPlayer.this._hasStarted = true;
                            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.START));
                            SambaPlayer.this.player.show();
                        }
                        SambaPlayer.this.dispatchPlay();
                        break;
                    }
                    SambaPlayer.this.dispatchPause();
                    break;
                }
                case 5: {
                    if (!playWhenReady) break;
                    SambaPlayer.this.stopProgressTimer();
                    SambaPlayer.this.pause();
                    SambaPlayer.this.seek(0.0f);
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FINISH));
                    SambaPlayer.this._hasFinished = true;
                }
            }
        }

        public void onError(Exception e) {
            boolean canFallback;
            Log.i((String)"SambaPlayer", (String)("Error: " + SambaPlayer.this.media), (Throwable)e);
            String msg = e.getCause() instanceof UnsupportedDrmException ? "You're not allowed to " + (((SambaPlayer)SambaPlayer.this).media.isAudioOnly ? "listen to this audio" : "watch this video") : e.getMessage();
            boolean bl = canFallback = ((SambaPlayer)SambaPlayer.this).media.backupUrls.length - SambaPlayer.this._currentBackupIndex > 0;
            if (canFallback) {
                String url = ((SambaPlayer)SambaPlayer.this).media.backupUrls[SambaPlayer.this._currentBackupIndex++];
                msg = String.format("Failed to load %s, falling back to %s", ((SambaPlayer)SambaPlayer.this).media.url, url);
                ((SambaPlayer)SambaPlayer.this).media.url = url;
                SambaPlayer.this.destroyInternal();
                SambaPlayer.this.create(false);
            }
            SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(e.hashCode(), msg, !canFallback));
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.RESIZE, width, height, unappliedRotationDegrees, Float.valueOf(pixelWidthHeightRatio)));
        }
    };
    private final PlaybackControlLayer.PlayCallback playListener = new PlaybackControlLayer.PlayCallback(){

        public void onPlay() {
            if (SambaPlayer.this.player.getPlaybackState() == 5) {
                SambaPlayer.this.seek(0.0f);
            }
        }
    };
    private final PlaybackControlLayer.FullscreenCallback fullscreenListener = new PlaybackControlLayer.FullscreenCallback(){

        public void onGoToFullscreen() {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN));
        }

        public void onReturnFromFullscreen() {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN_EXIT));
        }
    };
    private final AdapterView.OnItemClickListener outputMenuItemListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            SambaPlayer.this.player.closeOutputMenu();
            SambaPlayer.this.changeOutput((SambaMedia.Output)parent.getItemAtPosition(position));
        }
    };
    private final AdapterView.OnItemClickListener captionMenuItemListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            SambaPlayer.this.player.closeCaptionMenu();
            SambaPlayer.this.changeCaption(position);
        }
    };
    private final Runnable progressDispatcher = new Runnable(){

        @Override
        public void run() {
            if (SambaPlayer.this.player == null) {
                return;
            }
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PROGRESS, Float.valueOf(SambaPlayer.this.getCurrentTime()), Float.valueOf(SambaPlayer.this.getDuration())));
        }
    };
    private final SambaCastListener castListener = new SambaCastListener(){
        RemoteMediaClient castPlayer;
        private int lastPosition = 0;
        private final PlaybackControlLayer.InterceptableListener interceptableListener = new PlaybackControlLayer.InterceptableListener(){

            public boolean onPlay() {
                SambaPlayer.this.dispatchPlay();
                SambaPlayer.this.sambaCast.playCast();
                return false;
            }

            public boolean onPause() {
                SambaPlayer.this.dispatchPause();
                SambaPlayer.this.sambaCast.pauseCast();
                return false;
            }

            public boolean onSeek(int position) {
                SambaPlayer.this.sambaCast.seekTo(position);
                return false;
            }

            public int getCurrentTime() {
                return castPlayer != null ? (int)castPlayer.getApproximateStreamPosition() : 0;
            }

            public int getDuration() {
                return castPlayer != null ? (int)castPlayer.getStreamDuration() : 0;
            }
        };

        @Override
        public void onConnected(CastSession castSession) {
            SambaPlayer.this.stopProgressTimer();
            SambaPlayer.this.pause();
            RemoteMediaClient remoteMediaClient = castSession.getRemoteMediaClient();
            if (remoteMediaClient == null) {
                return;
            }
            SambaPlayer.this.player.setInterceptableListener(this.interceptableListener);
            SambaPlayer.this.player.setAutoHide(false);
            SambaPlayer.this.player.setControlsVisible(false, new String[]{"outputMenu", "captionMenu"});
            MediaMetadata movieMetadata = new MediaMetadata(1);
            movieMetadata.putString("com.google.android.gms.cast.metadata.TITLE", ((SambaPlayer)SambaPlayer.this).media.title);
            movieMetadata.putString("com.google.android.gms.cast.metadata.SUBTITLE", ((SambaPlayer)SambaPlayer.this).media.title);
            CastQuery qs = new CastQuery(true, CastOptionsProvider.environment.toString(), CastOptionsProvider.appId, (int)SambaPlayer.this.getCurrentTime(), SambaPlayer.this.getCaption());
            CastObject castObject = new CastObject(((SambaPlayer)SambaPlayer.this).media.title, ((SambaPlayer)SambaPlayer.this).media.id, (int)SambaPlayer.this.getDuration(), ((SambaPlayer)SambaPlayer.this).media.themeColorHex, ((SambaPlayer)SambaPlayer.this).media.projectHash, qs, "", CastOptionsProvider.playerUrl);
            if (((SambaPlayer)SambaPlayer.this).media.drmRequest != null) {
                castObject.setDrm(new CastDRM(((SambaPlayer)SambaPlayer.this).media.drmRequest.getLicenseParam("SessionId"), ((SambaPlayer)SambaPlayer.this).media.drmRequest.getLicenseParam("Ticket")));
            }
            MediaInfo mediaInfo = new MediaInfo.Builder(castObject.toString()).setStreamType(1).setContentType("video/mp4").setMetadata(movieMetadata).build();
            remoteMediaClient.load(mediaInfo, false, 0L).setResultCallback((ResultCallback)new ResultCallbacks<RemoteMediaClient.MediaChannelResult>(){

                public void onSuccess(@NonNull RemoteMediaClient.MediaChannelResult mediaChannelResult) {
                    Log.d((String)"load", (String)mediaChannelResult.getStatus().toString());
                }

                public void onFailure(@NonNull Status status) {
                    Log.d((String)"load", (String)status.toString());
                }
            });
            SambaPlayer.this.sambaCast.registerDeviceForProgress(true);
            this.lastPosition = 0;
            Cast.MessageReceivedCallback messageReceived = new Cast.MessageReceivedCallback(){

                public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
                    Log.i((String)"Message Received", (String)(castDevice.toString() + namespace + message));
                    try {
                        String type;
                        JSONObject jsonObject = new JSONObject(message);
                        if (jsonObject.has("progress") && jsonObject.has("duration")) {
                            float progress = jsonObject.getInt("progress");
                            float duration = jsonObject.getInt("duration");
                            lastPosition = (int)progress;
                            if (SambaPlayer.this.player != null) {
                                SambaPlayer.this.player.setCurrentTime(progress, duration);
                            }
                        } else if (jsonObject.has("type") && (type = (jsonObject = new JSONObject(message)).getString("type")).equalsIgnoreCase("finish")) {
                            SambaPlayer.this.sambaCast.stopCasting();
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            };
            try {
                castSession.setMessageReceivedCallbacks("urn:x-cast:com.sambatech.player", messageReceived);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.castPlayer = remoteMediaClient;
            SambaPlayer.this.player.updatePlayPauseButton(true);
        }

        @Override
        public void onDisconnected() {
            SambaPlayer.this.player.setControlsVisible(true, new String[]{SambaPlayer.this.outputMenu != null ? "outputMenu" : null, SambaPlayer.this.captionMenu != null ? "captionMenu" : null});
            SambaPlayer.this.player.setAutoHide(true);
            SambaPlayer.this.player.seek(this.lastPosition * 1000);
            this.lastPosition = 0;
            SambaPlayer.this.player.setInterceptableListener(null);
            SambaPlayer.this.play();
            SambaPlayer.this.startProgressTimer();
        }
    };
    private SimpleVideoPlayer player;
    private View _errorScreen;
    @NonNull
    private SambaMediaConfig media = new SambaMediaConfig();
    private Timer progressTimer;
    private boolean _hasStarted;
    private boolean _hasFinished;
    private OrientationEventListener orientationEventListener;
    private View outputMenu;
    private View captionMenu;
    private SambaCast sambaCast;
    private boolean autoFsMode;
    private boolean enableControls;
    private boolean _disabled;
    private int _currentBackupIndex;

    public SambaPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SambaPlayer, 0, 0));
    }

    public void setMedia(@NonNull SambaMedia media) {
        SambaMediaConfig m;
        this.media = m = new SambaMediaConfig(media);
        if (m.blockIfRooted && Helpers.isDeviceRooted()) {
            this._disabled = true;
            this.dispatchError(SambaPlayerError.rootedDevice);
            return;
        }
        this.destroy();
        PluginManager.getInstance().onLoad(this);
    }

    public SambaMedia getMedia() {
        return this.media;
    }

    public void play() {
        if (this._disabled) {
            return;
        }
        if (!PluginManager.getInstance().isLoaded()) {
            PluginManager.getInstance().setPendingPlay(true);
            return;
        }
        if (this.player == null) {
            this.create();
            return;
        }
        this.player.play();
    }

    public void pause() {
        if (this.player == null || !this._hasStarted) {
            return;
        }
        this.player.pause();
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        this.player.stop();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.STOP));
    }

    public void seek(float position) {
        if (this.player == null) {
            return;
        }
        this.player.seek(Math.round(position * 1000.0f));
    }

    public void setEnableControls(boolean flag) {
        if (this.media.isAudioOnly) {
            return;
        }
        if (this.player != null) {
            if (flag) {
                this.player.enableControls();
            } else {
                this.player.disableControls();
            }
        } else {
            this.enableControls = flag;
        }
    }

    public void setFullscreen(boolean flag) {
        if (this.player == null) {
            return;
        }
        this.player.setFullscreen(flag);
    }

    public boolean isFullscreen() {
        return this.player != null && this.player.isFullscreen();
    }

    public void show() {
        if (this.player == null) {
            return;
        }
        this.player.show();
    }

    public void hide() {
        if (this.player == null) {
            return;
        }
        this.player.hide();
    }

    public void setAutoFullscreenMode(boolean flag) {
        this.autoFsMode = flag;
    }

    public float getCurrentTime() {
        return this.player != null ? (float)this.player.getCurrentPosition() / 1000.0f : 0.0f;
    }

    public float getDuration() {
        return this.player != null ? (float)this.player.getDuration() / 1000.0f : this.media.duration;
    }

    public boolean isPlaying() {
        return this.player != null && this.player.shouldBePlaying();
    }

    public boolean hasStarted() {
        return this._hasStarted;
    }

    public boolean hasFinished() {
        return this._hasFinished;
    }

    public void changeOutput(@NonNull SambaMedia.Output output) {
        if (output.url == null || output.url.isEmpty()) {
            Log.e((String)"SambaPlayer", (String)("URL not found for output \"" + output.label + "\"."));
            return;
        }
        int currentPosition = this.player.getCurrentPosition();
        for (SambaMedia.Output o : this.media.outputs) {
            o.isDefault = o.label.equals(output.label);
        }
        this.media.url = output.url;
        this.destroyInternal();
        this.create(false);
        this.player.seek(currentPosition);
    }

    public void changeCaption(int index) {
        Captions plugin = (Captions)PluginManager.getInstance().getPlugin(Captions.class);
        if (plugin == null) {
            return;
        }
        plugin.changeCaption(index);
    }

    public String getCaption() {
        if (this.captionMenu == null) {
            return null;
        }
        CaptionsAdapter adapter = (CaptionsAdapter)((ListView)this.captionMenu.findViewById(R.id.menu_list)).getAdapter();
        SambaMedia.Caption caption = (SambaMedia.Caption)adapter.getItem(adapter.currentIndex);
        return String.format("[%s,ffcc00,42]", caption.language);
    }

    public void setSambaCast(@NonNull SambaCast sambaCast) {
        this.sambaCast = sambaCast;
        this.setupCast();
    }

    public void destroy() {
        this.destroy(null);
    }

    public void destroy(SambaPlayerError error) {
        PluginManager.getInstance().onDestroy();
        this.destroyInternal();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.UNLOAD));
        if (error != null) {
            this.showError(error);
        } else {
            this.destroyScreen();
        }
    }

    private void applyAttributes(TypedArray attrs) {
        try {
            this.setAutoFullscreenMode(attrs.getBoolean(R.styleable.SambaPlayer_autoFullscreenMode, false));
            this.setEnableControls(attrs.getBoolean(R.styleable.SambaPlayer_enableControls, true));
        }
        finally {
            attrs.recycle();
        }
    }

    private void create() {
        this.create(true);
    }

    private void create(boolean notify) {
        if (this.player != null) {
            Log.i((String)"SambaPlayer", (String)"Player already created!");
            return;
        }
        if (this.media.url == null || this.media.url.isEmpty()) {
            this.dispatchError(SambaPlayerError.emptyUrl);
            return;
        }
        Video.VideoType videoType = Video.VideoType.OTHER;
        switch (this.media.type.toLowerCase()) {
            case "hls": {
                videoType = Video.VideoType.HLS;
                break;
            }
            case "dash": {
                videoType = Video.VideoType.DASH;
            }
        }
        this.player = new SimpleVideoPlayer((Activity)this.getContext(), (FrameLayout)this, new Video(this.media.url, videoType, this.media.drmRequest), this.media.title, !(this.sambaCast != null && this.sambaCast.isCasting() || this.media.adUrl != null && !this.media.adUrl.isEmpty()), this.media.isAudioOnly);
        this.player.setSeekbarColor(this.media.themeColor);
        this.player.moveSurfaceToBackground();
        if (this.media.isLive) {
            ((Activity)this.getContext()).findViewById(R.id.time_container).setVisibility(4);
            this.player.setControlsVisible(false, new String[]{"seekbar"});
            this.player.addActionButton(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_live), this.getContext().getString(R.string.live), null);
        }
        this.player.addPlaybackListener(this.playbackListener);
        this.player.setPlayCallback(this.playListener);
        if (this.media.isAudioOnly) {
            this.player.setControlsVisible(true, new String[]{"play"});
            this.player.setControlsVisible(false, new String[]{"fullscreen", "playLarge", "topChrome"});
            this.player.setBackgroundColor(-12369085);
            this.player.setChromeColor(0);
        } else {
            this.player.setFullscreenCallback(this.fullscreenListener);
        }
        this.orientationEventListener = new OrientationEventListener(this.getContext()){
            {
                this.enable();
            }

            public void onOrientationChanged(int orientation) {
                if (Settings.System.getInt((ContentResolver)SambaPlayer.this.getContext().getContentResolver(), (String)"accelerometer_rotation", (int)0) == 0 || !SambaPlayer.this.autoFsMode || SambaPlayer.this.player == null) {
                    return;
                }
                if (orientation <= 15 && orientation >= 0) {
                    if (SambaPlayer.this.player.isFullscreen()) {
                        SambaPlayer.this.player.setFullscreen(false);
                    }
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PORTRAIT));
                } else if (orientation >= 80 && orientation <= 100 || orientation >= 260 && orientation <= 290) {
                    if (!SambaPlayer.this.player.isFullscreen()) {
                        SambaPlayer.this.player.setFullscreen(true);
                    }
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LANDSCAPE));
                }
            }
        };
        if (!this.media.isAudioOnly) {
            if (this.media.outputs != null && this.media.outputs.size() > 1) {
                this.outputMenu = ((Activity)this.getContext()).getLayoutInflater().inflate(R.layout.menu_layout, null);
                TextView cancelButton = (TextView)this.outputMenu.findViewById(R.id.menu_cancel_button);
                cancelButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SambaPlayer.this.player.closeOutputMenu();
                    }
                });
                OutputAdapter outputAdapter = new OutputAdapter(this.getContext(), this.media.outputs);
                ListView outputMenuList = (ListView)this.outputMenu.findViewById(R.id.menu_list);
                outputMenuList.setAdapter((ListAdapter)outputAdapter);
                outputMenuList.setOnItemClickListener(this.outputMenuItemListener);
                outputAdapter.notifyDataSetChanged();
                this.player.setOutputMenu(this.outputMenu);
            }
            if (this.media.captions != null && this.media.captions.size() > 0) {
                this.captionMenu = ((Activity)this.getContext()).getLayoutInflater().inflate(R.layout.menu_layout, null);
                TextView captionCancelButton = (TextView)this.captionMenu.findViewById(R.id.menu_cancel_button);
                TextView captionTitle = (TextView)this.captionMenu.findViewById(R.id.menu_label);
                captionTitle.setText((CharSequence)this.getContext().getString(R.string.captions));
                captionCancelButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SambaPlayer.this.player.closeCaptionMenu();
                    }
                });
                CaptionsAdapter captionsAdapter = new CaptionsAdapter(this.getContext(), this.media.captions);
                ListView captionMenuList = (ListView)this.captionMenu.findViewById(R.id.menu_list);
                captionMenuList.setAdapter((ListAdapter)captionsAdapter);
                captionMenuList.setOnItemClickListener(this.captionMenuItemListener);
                captionMenuList.deferNotifyDataSetChanged();
                this.player.setCaptionMenu(this.captionMenu);
            }
            if (!this.enableControls) {
                this.player.disableControls();
            }
            PluginManager.getInstance().onInternalPlayerCreated(this.player);
            if (notify) {
                SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LOAD, new Object[]{this}));
            }
        }
        this.setupCast();
        if (this.sambaCast != null && this.sambaCast.isCasting()) {
            this.castListener.onConnected(this.sambaCast.getCastSession());
        }
    }

    private void destroyInternal() {
        if (this.player == null) {
            return;
        }
        this.stopProgressTimer();
        this.stop();
        if (this.outputMenu != null) {
            ((ListView)this.outputMenu.findViewById(R.id.menu_list)).setOnItemClickListener(null);
            this.outputMenu.findViewById(R.id.menu_cancel_button).setOnClickListener(null);
        }
        if (this.captionMenu != null) {
            ((ListView)this.captionMenu.findViewById(R.id.menu_list)).setOnItemClickListener(null);
            this.captionMenu.findViewById(R.id.menu_cancel_button).setOnClickListener(null);
        }
        this.orientationEventListener.disable();
        this.player.removePlaybackListener(this.playbackListener);
        this.player.setPlayCallback(null);
        this.player.setFullscreenCallback(null);
        if (this.sambaCast != null) {
            this.sambaCast.setEventListener(null);
        }
        this.player.release();
        this.outputMenu = null;
        this.captionMenu = null;
        this.orientationEventListener = null;
        this.player = null;
        this._hasStarted = false;
        this._hasFinished = false;
        this._disabled = false;
    }

    private void showError(@NonNull SambaPlayerError error) {
        this.destroyScreen();
        this._errorScreen = ((Activity)this.getContext()).getLayoutInflater().inflate(R.layout.error_screen, (ViewGroup)this, false);
        TextView msg = (TextView)this._errorScreen.findViewById(R.id.error_message);
        msg.setText((CharSequence)error.toString());
        if (this.media.isAudioOnly) {
            msg.setCompoundDrawables(null, null, null, null);
        }
        this.addView(this._errorScreen);
    }

    private void destroyScreen() {
        if (this._errorScreen == null) {
            return;
        }
        this.removeView(this._errorScreen);
        this._errorScreen = null;
    }

    private void startProgressTimer() {
        if (this.progressTimer != null) {
            return;
        }
        this.progressTimer = new Timer();
        this.progressTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)SambaPlayer.this.getContext()).runOnUiThread(SambaPlayer.this.progressDispatcher);
            }
        }, 0L, 250L);
    }

    private void stopProgressTimer() {
        if (this.progressTimer == null) {
            return;
        }
        this.progressTimer.cancel();
        this.progressTimer.purge();
        this.progressTimer = null;
    }

    private void dispatchPlay() {
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PLAY));
        this.startProgressTimer();
    }

    private void dispatchPause() {
        this.stopProgressTimer();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PAUSE));
    }

    private void dispatchError(@NonNull SambaPlayerError error) {
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.ERROR, new Object[]{error}));
        if (error.isCritical()) {
            this.destroy(error);
        }
    }

    private void setupCast() {
        if (this.sambaCast == null || this.media.isLive || this.media.isAudioOnly) {
            return;
        }
        this.sambaCast.setEventListener(this.castListener);
        if (this.player != null) {
            MediaRouteButton button = this.sambaCast.getButton();
            ViewGroup parent = (ViewGroup)button.getParent();
            if (parent != null) {
                parent.removeView((View)button);
            }
            this.player.addActionButton((View)button);
        }
    }
}

