/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.google.android.libraries.mediaframework.exoplayerextensions.UnsupportedDrmException;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.layeredvideo.PlaybackControlLayer;
import com.google.android.libraries.mediaframework.layeredvideo.SimpleVideoPlayer;
import com.sambatech.player.R;
import com.sambatech.player.adapter.CaptionsAdapter;
import com.sambatech.player.adapter.OutputAdapter;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.model.SambaPlayerError;
import com.sambatech.player.plugins.Captions;
import com.sambatech.player.plugins.PluginManager;
import com.sambatech.player.utils.Helpers;
import java.util.Timer;
import java.util.TimerTask;

public class SambaPlayer
extends FrameLayout {
    private SimpleVideoPlayer player;
    private View _errorScreen;
    @NonNull
    private SambaMediaConfig media = new SambaMediaConfig();
    private Timer progressTimer;
    private boolean _hasStarted;
    private boolean _hasFinished;
    private OrientationEventListener orientationEventListener;
    private View outputMenu;
    private View captionMenu;
    private boolean autoFsMode;
    private boolean enableControls;
    private boolean _disabled;
    private int _currentBackupIndex;
    private final ExoplayerWrapper.PlaybackListener playbackListener = new ExoplayerWrapper.PlaybackListener(){

        public void onStateChanged(boolean playWhenReady, int playbackState) {
            Log.i((String)"SambaPlayer", (String)("state: " + playWhenReady + " " + playbackState + "; playing: " + SambaPlayer.this.isPlaying()));
            switch (playbackState) {
                case 4: {
                    if (playWhenReady) {
                        if (!SambaPlayer.this._hasStarted) {
                            SambaPlayer.this._hasStarted = true;
                            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.START));
                            SambaPlayer.this.player.show();
                        }
                        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PLAY));
                        SambaPlayer.this.startProgressTimer();
                        break;
                    }
                    SambaPlayer.this.stopProgressTimer();
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PAUSE));
                    break;
                }
                case 5: {
                    if (!playWhenReady) break;
                    SambaPlayer.this.stopProgressTimer();
                    SambaPlayer.this.pause();
                    SambaPlayer.this.seek(0.0f);
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FINISH));
                    SambaPlayer.this._hasFinished = true;
                }
            }
        }

        public void onError(Exception e) {
            boolean canFallback;
            Log.i((String)"SambaPlayer", (String)("Error: " + SambaPlayer.this.media), (Throwable)e);
            String msg = e.getCause() instanceof UnsupportedDrmException ? "You're not allowed to " + (((SambaPlayer)SambaPlayer.this).media.isAudioOnly ? "listen to this audio" : "watch this video") : e.getMessage();
            boolean bl = canFallback = ((SambaPlayer)SambaPlayer.this).media.backupUrls.length - SambaPlayer.this._currentBackupIndex > 0;
            if (canFallback) {
                String url = ((SambaPlayer)SambaPlayer.this).media.backupUrls[SambaPlayer.this._currentBackupIndex++];
                msg = String.format("Failed to load %s, falling back to %s", ((SambaPlayer)SambaPlayer.this).media.url, url);
                ((SambaPlayer)SambaPlayer.this).media.url = url;
                SambaPlayer.this.destroyInternal();
                SambaPlayer.this.create(false);
            }
            SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(e.hashCode(), msg, !canFallback));
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.RESIZE, width, height, unappliedRotationDegrees, Float.valueOf(pixelWidthHeightRatio)));
        }
    };
    private final PlaybackControlLayer.PlayCallback playListener = new PlaybackControlLayer.PlayCallback(){

        public void onPlay() {
            if (SambaPlayer.this.player.getPlaybackState() == 5) {
                SambaPlayer.this.seek(0.0f);
            }
        }
    };
    private final PlaybackControlLayer.FullscreenCallback fullscreenListener = new PlaybackControlLayer.FullscreenCallback(){

        public void onGoToFullscreen() {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN));
        }

        public void onReturnFromFullscreen() {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN_EXIT));
        }
    };
    private final AdapterView.OnItemClickListener outputMenuItemListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            SambaPlayer.this.player.closeOutputMenu();
            SambaPlayer.this.changeOutput((SambaMedia.Output)parent.getItemAtPosition(position));
        }
    };
    private final AdapterView.OnItemClickListener captionMenuItemListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            SambaPlayer.this.player.closeCaptionMenu();
            SambaPlayer.this.changeCaption(position);
        }
    };
    private final Runnable progressDispatcher = new Runnable(){

        @Override
        public void run() {
            if (SambaPlayer.this.player == null) {
                return;
            }
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PROGRESS, Float.valueOf(SambaPlayer.this.getCurrentTime()), Float.valueOf(SambaPlayer.this.getDuration())));
        }
    };

    public SambaPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SambaPlayer, 0, 0));
    }

    public void setMedia(@NonNull SambaMedia media) {
        SambaMediaConfig m;
        this.media = m = new SambaMediaConfig(media);
        if (m.blockIfRooted && Helpers.isDeviceRooted()) {
            this._disabled = true;
            this.dispatchError(SambaPlayerError.rootedDevice);
            return;
        }
        this.destroy();
        PluginManager.getInstance().onLoad(this);
    }

    public SambaMedia getMedia() {
        return this.media;
    }

    public void play() {
        if (this._disabled) {
            return;
        }
        if (!PluginManager.getInstance().isLoaded()) {
            PluginManager.getInstance().setPendingPlay(true);
            return;
        }
        if (this.player == null) {
            this.create();
            return;
        }
        this.player.play();
    }

    public void pause() {
        if (this.player == null || !this._hasStarted) {
            return;
        }
        this.player.pause();
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        this.player.stop();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.STOP));
    }

    public void seek(float position) {
        if (this.player == null) {
            return;
        }
        this.player.seek(Math.round(position * 1000.0f));
    }

    public void setEnableControls(boolean flag) {
        if (this.media.isAudioOnly) {
            return;
        }
        if (this.player != null) {
            if (flag) {
                this.player.enableControls();
            } else {
                this.player.disableControls();
            }
        } else {
            this.enableControls = flag;
        }
    }

    public void setFullscreen(boolean flag) {
        if (this.player == null) {
            return;
        }
        this.player.setFullscreen(flag);
    }

    public boolean isFullscreen() {
        return this.player != null && this.player.isFullscreen();
    }

    public void show() {
        if (this.player == null) {
            return;
        }
        this.player.show();
    }

    public void hide() {
        if (this.player == null) {
            return;
        }
        this.player.hide();
    }

    public void setAutoFullscreenMode(boolean flag) {
        this.autoFsMode = flag;
    }

    public float getCurrentTime() {
        return this.player != null ? (float)this.player.getCurrentPosition() / 1000.0f : 0.0f;
    }

    public float getDuration() {
        return this.player != null ? (float)this.player.getDuration() / 1000.0f : 0.0f;
    }

    public boolean isPlaying() {
        return this.player != null && this.player.shouldBePlaying();
    }

    public boolean hasStarted() {
        return this._hasStarted;
    }

    public boolean hasFinished() {
        return this._hasFinished;
    }

    public void changeOutput(@NonNull SambaMedia.Output output) {
        if (output.url == null || output.url.isEmpty()) {
            Log.e((String)"SambaPlayer", (String)("URL not found for output \"" + output.label + "\"."));
            return;
        }
        int currentPosition = this.player.getCurrentPosition();
        for (SambaMedia.Output o : this.media.outputs) {
            o.isDefault = o.label.equals(output.label);
        }
        this.media.url = output.url;
        this.destroyInternal();
        this.create(false);
        this.player.seek(currentPosition);
    }

    public void changeCaption(int index) {
        Captions plugin = (Captions)PluginManager.getInstance().getPlugin(Captions.class);
        if (plugin == null) {
            return;
        }
        plugin.changeCaption(index);
    }

    public void destroy() {
        this.destroy(null);
    }

    public void destroy(SambaPlayerError error) {
        PluginManager.getInstance().onDestroy();
        this.destroyInternal();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.UNLOAD));
        if (error != null) {
            this.showError(error);
        } else {
            this.destroyScreen();
        }
    }

    private void applyAttributes(TypedArray attrs) {
        try {
            this.setAutoFullscreenMode(attrs.getBoolean(R.styleable.SambaPlayer_autoFullscreenMode, false));
            this.setEnableControls(attrs.getBoolean(R.styleable.SambaPlayer_enableControls, true));
        }
        finally {
            attrs.recycle();
        }
    }

    private void create() {
        this.create(true);
    }

    private void create(boolean notify) {
        if (this.player != null) {
            Log.i((String)"SambaPlayer", (String)"Player already created!");
            return;
        }
        if (this.media.url == null || this.media.url.isEmpty()) {
            this.dispatchError(SambaPlayerError.emptyUrl);
            return;
        }
        Video.VideoType videoType = Video.VideoType.OTHER;
        switch (this.media.type.toLowerCase()) {
            case "hls": {
                videoType = Video.VideoType.HLS;
                break;
            }
            case "dash": {
                videoType = Video.VideoType.DASH;
            }
        }
        this.player = new SimpleVideoPlayer((Activity)this.getContext(), (FrameLayout)this, new Video(this.media.url, videoType, this.media.drmRequest), this.media.title, this.media.adUrl == null || this.media.adUrl.isEmpty(), this.media.isAudioOnly);
        this.player.setSeekbarColor(this.media.themeColor);
        this.player.moveSurfaceToBackground();
        if (this.media.isLive) {
            ((Activity)this.getContext()).findViewById(R.id.time_container).setVisibility(4);
            this.player.setControlsVisible(false, new String[]{"seekbar"});
            this.player.addActionButton(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_live), this.getContext().getString(R.string.live), null);
        }
        this.player.addPlaybackListener(this.playbackListener);
        this.player.setPlayCallback(this.playListener);
        if (this.media.isAudioOnly) {
            this.player.setControlsVisible(true, new String[]{"play"});
            this.player.setControlsVisible(false, new String[]{"fullscreen", "playLarge", "topChrome"});
            this.player.setBackgroundColor(-12369085);
            this.player.setChromeColor(0);
        } else {
            this.player.setFullscreenCallback(this.fullscreenListener);
        }
        this.orientationEventListener = new OrientationEventListener(this.getContext()){
            {
                this.enable();
            }

            public void onOrientationChanged(int orientation) {
                if (Settings.System.getInt((ContentResolver)SambaPlayer.this.getContext().getContentResolver(), (String)"accelerometer_rotation", (int)0) == 0 || !SambaPlayer.this.autoFsMode || SambaPlayer.this.player == null) {
                    return;
                }
                if (orientation <= 15 && orientation >= 0) {
                    if (SambaPlayer.this.player.isFullscreen()) {
                        SambaPlayer.this.player.setFullscreen(false);
                    }
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PORTRAIT));
                } else if (orientation >= 80 && orientation <= 100 || orientation >= 260 && orientation <= 290) {
                    if (!SambaPlayer.this.player.isFullscreen()) {
                        SambaPlayer.this.player.setFullscreen(true);
                    }
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LANDSCAPE));
                }
            }
        };
        if (!this.media.isAudioOnly) {
            if (this.media.outputs != null && this.media.outputs.size() > 1) {
                this.outputMenu = ((Activity)this.getContext()).getLayoutInflater().inflate(R.layout.menu_layout, null);
                TextView cancelButton = (TextView)this.outputMenu.findViewById(R.id.menu_cancel_button);
                cancelButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SambaPlayer.this.player.closeOutputMenu();
                    }
                });
                OutputAdapter outputAdapter = new OutputAdapter(this.getContext(), this.media.outputs);
                ListView outputMenuList = (ListView)this.outputMenu.findViewById(R.id.menu_list);
                outputMenuList.setAdapter((ListAdapter)outputAdapter);
                outputMenuList.setOnItemClickListener(this.outputMenuItemListener);
                outputAdapter.notifyDataSetChanged();
                this.player.setOutputMenu(this.outputMenu);
            }
            if (this.media.captions != null && this.media.captions.size() > 0) {
                this.captionMenu = ((Activity)this.getContext()).getLayoutInflater().inflate(R.layout.menu_layout, null);
                TextView captionCancelButton = (TextView)this.captionMenu.findViewById(R.id.menu_cancel_button);
                TextView captionTitle = (TextView)this.captionMenu.findViewById(R.id.menu_label);
                captionTitle.setText((CharSequence)this.getContext().getString(R.string.captions));
                captionCancelButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SambaPlayer.this.player.closeCaptionMenu();
                    }
                });
                CaptionsAdapter captionsAdapter = new CaptionsAdapter(this.getContext(), this.media.captions);
                ListView captionMenuList = (ListView)this.captionMenu.findViewById(R.id.menu_list);
                captionMenuList.setAdapter((ListAdapter)captionsAdapter);
                captionMenuList.setOnItemClickListener(this.captionMenuItemListener);
                captionMenuList.deferNotifyDataSetChanged();
                this.player.setCaptionMenu(this.captionMenu);
            }
            if (!this.enableControls) {
                this.player.disableControls();
            }
            PluginManager.getInstance().onInternalPlayerCreated(this.player);
            if (notify) {
                SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LOAD, new Object[]{this}));
            }
        }
    }

    private void destroyInternal() {
        if (this.player == null) {
            return;
        }
        this.stopProgressTimer();
        this.stop();
        if (this.outputMenu != null) {
            ((ListView)this.outputMenu.findViewById(R.id.menu_list)).setOnItemClickListener(null);
            this.outputMenu.findViewById(R.id.menu_cancel_button).setOnClickListener(null);
        }
        if (this.captionMenu != null) {
            ((ListView)this.captionMenu.findViewById(R.id.menu_list)).setOnItemClickListener(null);
            this.captionMenu.findViewById(R.id.menu_cancel_button).setOnClickListener(null);
        }
        this.orientationEventListener.disable();
        this.player.removePlaybackListener(this.playbackListener);
        this.player.setPlayCallback(null);
        this.player.setFullscreenCallback(null);
        this.player.release();
        this.outputMenu = null;
        this.orientationEventListener = null;
        this.player = null;
        this._hasStarted = false;
        this._hasFinished = false;
        this._disabled = false;
    }

    private void showError(@NonNull SambaPlayerError error) {
        this.destroyScreen();
        this._errorScreen = ((Activity)this.getContext()).getLayoutInflater().inflate(R.layout.error_screen, (ViewGroup)this, false);
        TextView msg = (TextView)this._errorScreen.findViewById(R.id.error_message);
        msg.setText((CharSequence)error.toString());
        if (this.media != null && this.media.isAudioOnly) {
            msg.setCompoundDrawables(null, null, null, null);
        }
        this.addView(this._errorScreen);
    }

    private void destroyScreen() {
        if (this._errorScreen == null) {
            return;
        }
        this.removeView(this._errorScreen);
        this._errorScreen = null;
    }

    private void startProgressTimer() {
        if (this.progressTimer != null) {
            return;
        }
        this.progressTimer = new Timer();
        this.progressTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)SambaPlayer.this.getContext()).runOnUiThread(SambaPlayer.this.progressDispatcher);
            }
        }, 0L, 250L);
    }

    private void stopProgressTimer() {
        if (this.progressTimer == null) {
            return;
        }
        this.progressTimer.cancel();
        this.progressTimer.purge();
        this.progressTimer = null;
    }

    private void dispatchError(@NonNull SambaPlayerError error) {
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.ERROR, new Object[]{error}));
        if (error.isCritical()) {
            this.destroy(error);
        }
    }
}

