/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.plugins;

import android.support.annotation.NonNull;
import android.util.Log;
import android.view.View;
import android.widget.ListView;
import com.google.android.libraries.mediaframework.layeredvideo.SimpleVideoPlayer;
import com.google.android.libraries.mediaframework.layeredvideo.SubtitleLayer;
import com.sambatech.player.R;
import com.sambatech.player.SambaPlayer;
import com.sambatech.player.adapter.CaptionsAdapter;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.plugins.Plugin;
import com.sambatech.player.plugins.PluginManager;
import com.sambatech.player.utils.Helpers;
import java.util.ArrayList;
import java.util.HashMap;

public final class Captions
extends SambaPlayerListener
implements Plugin {
    private SubtitleLayer _subtitleLayer;
    private SambaPlayer _player;
    @NonNull
    private ArrayList<SambaMedia.Caption> _captionsRequest = new ArrayList();
    private SambaMedia.CaptionsConfig _config;
    private HashMap<Integer, Caption[]> _captionsMap;
    private Caption _currentCaption;
    private int _currentIndex = -1;
    private boolean _parsed;
    private SimpleVideoPlayer _internalPlayer;

    public void changeCaption(int index) {
        if (index == this._currentIndex || index >= this._captionsRequest.size()) {
            return;
        }
        this._currentIndex = index;
        View captionsMenu = this._internalPlayer.getCaptionMenu();
        if (captionsMenu != null) {
            ((CaptionsAdapter)((ListView)captionsMenu.findViewById((int)R.id.menu_list)).getAdapter()).currentIndex = index;
        }
        this._parsed = false;
        this._currentCaption = null;
        this._subtitleLayer.onText("");
        SambaMedia.Caption captionRequest = this._captionsRequest.get(index);
        if (captionRequest.url == null || captionRequest.url.isEmpty()) {
            return;
        }
        Helpers.requestUrl(captionRequest.url, new Helpers.RequestCallback(){

            @Override
            public void onSuccess(String response) {
                Log.i((String)"SambaPlayer::captions", (String)"parsing...");
                Captions.this.parse(response.substring(1));
            }

            @Override
            public void onError(Exception e, String response) {
                Log.e((String)"SambaPlayer::captions", (String)response, (Throwable)e);
            }
        });
    }

    @Override
    public void onLoad(@NonNull SambaPlayer player) {
        this._player = player;
        SambaMedia media = player.getMedia();
        try {
            if (media == null || media.captions == null || media.captions.size() == 0) {
                return;
            }
            this._captionsRequest = media.captions;
            this._config = media.captionsConfig;
            SambaEventBus.subscribe(this);
        }
        finally {
            PluginManager.getInstance().notifyPluginLoaded(this);
        }
    }

    @Override
    public void onInternalPlayerCreated(@NonNull SimpleVideoPlayer internalPlayer) {
        this._internalPlayer = internalPlayer;
        this._subtitleLayer = internalPlayer.getSubtitleLayer();
        if (this._captionsRequest.size() == 0) {
            return;
        }
        int index = 0;
        for (SambaMedia.Caption c : this._captionsRequest) {
            if (this._config.language != null && c.language.toLowerCase().replace('_', '-').equals(this._config.language) || c.isDefault) break;
            ++index;
        }
        this._subtitleLayer.getTextView().setTextColor(this._config.color);
        this._subtitleLayer.getTextView().setTextSize(this._config.size);
        this.changeCaption(index);
    }

    @Override
    public void onDestroy() {
        SambaEventBus.unsubscribe(this);
    }

    @Override
    public void onProgress(SambaEvent event) {
        if (this._subtitleLayer == null || !this._parsed) {
            return;
        }
        float time = this._player.getCurrentTime();
        int m = (int)(time / 60.0f);
        if (!this._captionsMap.containsKey(m)) {
            return;
        }
        Caption[] captions = this._captionsMap.get(m);
        boolean notFound = true;
        for (Caption caption : captions) {
            if (time < caption.startTime || time > caption.endTime) continue;
            notFound = false;
            if (this._currentCaption != null && this._currentCaption.index == caption.index) break;
            this._subtitleLayer.onText(caption.text);
            this._currentCaption = caption;
            break;
        }
        if (notFound) {
            this._subtitleLayer.onText("");
            this._currentCaption = null;
        }
    }

    private void parse(String captionsText) {
        this._parsed = false;
        this._captionsMap = new HashMap();
        ArrayList<Caption> captions = new ArrayList<Caption>();
        int index = -1;
        float startTime = 0.0f;
        float endTime = 0.0f;
        String text = "";
        int count = 0;
        int mLast = 0;
        for (String s : captionsText.split("[\\r\\n]+")) {
            if (s.matches("^\\d+$")) {
                if (index != -1) {
                    int m = (int)(startTime / 60.0f);
                    if (m != mLast) {
                        this._captionsMap.put(mLast, captions.toArray(new Caption[captions.size()]));
                        captions = new ArrayList();
                        mLast = m;
                    }
                    captions.add(new Caption(index, startTime, endTime, text));
                }
                try {
                    index = Integer.parseInt(s);
                }
                catch (Exception e) {
                    index = -1;
                }
                startTime = 0.0f;
                endTime = 0.0f;
                text = "";
                count = 1;
                continue;
            }
            switch (count) {
                case 1: {
                    String[] time = s.split("\\D+");
                    startTime = this.extractTime(time).floatValue();
                    endTime = this.extractTime(time, 4).floatValue();
                    break;
                }
                default: {
                    text = text + (count > 2 ? " " : "") + s;
                }
            }
            ++count;
        }
        if (index != -1) {
            captions.add(new Caption(index, startTime, endTime, text));
            this._captionsMap.put(mLast, captions.toArray(new Caption[captions.size()]));
        }
        this._parsed = true;
    }

    private Float extractTime(String[] timeInterval, int offset) {
        if (timeInterval.length == 0 && (timeInterval.length + offset) % 4 != 0) {
            return Float.valueOf(0.0f);
        }
        try {
            int h = Integer.parseInt(timeInterval[offset]);
            int m = Integer.parseInt(timeInterval[1 + offset]);
            int s = Integer.parseInt(timeInterval[2 + offset]);
            int ms = Integer.parseInt(timeInterval[3 + offset]);
            return Float.valueOf((float)(h * 3600 + m * 60 + s) + (float)ms / 1000.0f);
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    private Float extractTime(String[] timeInterval) {
        return this.extractTime(timeInterval, 0);
    }

    private static final class Caption {
        final int index;
        final float startTime;
        final float endTime;
        final String text;

        public Caption(int index, float startTime, float endTime, String text) {
            this.index = index;
            this.startTime = startTime;
            this.endTime = endTime;
            this.text = text;
        }
    }
}

