/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.View;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.google.android.libraries.mediaframework.exoplayerextensions.ExoplayerWrapper;
import com.google.android.libraries.mediaframework.exoplayerextensions.Video;
import com.google.android.libraries.mediaframework.layeredvideo.PlaybackControlLayer;
import com.google.android.libraries.mediaframework.layeredvideo.SimpleVideoPlayer;
import com.sambatech.player.R;
import com.sambatech.player.SambaPlayer;
import com.sambatech.player.adapter.OutputAdapter;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import java.util.Timer;
import java.util.TimerTask;

public class SambaPlayerController
implements SambaPlayer {
    private SimpleVideoPlayer player;
    private SambaMediaConfig media = new SambaMediaConfig();
    private Timer progressTimer;
    private boolean _hasStarted;
    private boolean _hasFinished;
    private FrameLayout view;
    private OrientationEventListener orientationEventListener;
    private View outputMenu;
    private boolean autoFsMode;
    private boolean enableControls;
    private final ExoplayerWrapper.PlaybackListener playbackListener = new ExoplayerWrapper.PlaybackListener(){

        public void onStateChanged(boolean playWhenReady, int playbackState) {
            Log.i((String)"player", (String)("state: " + playWhenReady + " " + playbackState));
            switch (playbackState) {
                case 4: {
                    if (playWhenReady) {
                        if (!SambaPlayerController.this._hasStarted) {
                            SambaPlayerController.this._hasStarted = true;
                            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.START));
                            SambaPlayerController.this.player.show();
                        }
                        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PLAY));
                        SambaPlayerController.this.startProgressTimer();
                        break;
                    }
                    SambaPlayerController.this.stopProgressTimer();
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PAUSE));
                    break;
                }
                case 5: {
                    if (!playWhenReady) break;
                    SambaPlayerController.this.stopProgressTimer();
                    SambaPlayerController.this.pause();
                    SambaPlayerController.this.seek(0.0f);
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FINISH));
                    SambaPlayerController.this._hasFinished = true;
                }
            }
        }

        public void onError(Exception e) {
            Log.i((String)"player", (String)("Error: " + SambaPlayerController.this.media), (Throwable)e);
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.ERROR, e.getMessage()));
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.RESIZE, width, height, unappliedRotationDegrees, Float.valueOf(pixelWidthHeightRatio)));
        }
    };
    private final PlaybackControlLayer.PlayCallback playListener = new PlaybackControlLayer.PlayCallback(){

        public void onPlay() {
            if (SambaPlayerController.this.player.getPlaybackState() == 5) {
                SambaPlayerController.this.seek(0.0f);
            }
        }
    };
    private final PlaybackControlLayer.FullscreenCallback fullscreenListener = new PlaybackControlLayer.FullscreenCallback(){

        public void onGoToFullscreen() {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN));
        }

        public void onReturnFromFullscreen() {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN_EXIT));
        }
    };
    private final AdapterView.OnItemClickListener menuItemListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            SambaPlayerController.this.player.closeOutputMenu();
            SambaPlayerController.this.changeOutput((SambaMedia.Output)parent.getItemAtPosition(position));
        }
    };
    private final Runnable progressDispatcher = new Runnable(){

        @Override
        public void run() {
            if (SambaPlayerController.this.player == null) {
                return;
            }
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PROGRESS, Float.valueOf(SambaPlayerController.this.getCurrentTime()), Float.valueOf(SambaPlayerController.this.getDuration())));
        }
    };

    public SambaPlayerController(FrameLayout view) {
        this.view = view;
    }

    @Override
    public void setMedia(SambaMedia media) {
        if (media == null) {
            throw new IllegalArgumentException("Media data is null");
        }
        this.media = new SambaMediaConfig(media);
        this.destroy();
    }

    @Override
    public SambaMedia getMedia() {
        return this.media;
    }

    @Override
    public void play() {
        if (this.player != null) {
            this.player.play();
        } else {
            this.create();
        }
    }

    @Override
    public void pause() {
        if (this._hasStarted) {
            this.player.pause();
        }
    }

    @Override
    public void stop() {
        this.player.stop();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.STOP));
    }

    @Override
    public void seek(float position) {
        this.player.seek(Math.round(position * 1000.0f));
    }

    @Override
    public void setFullscreen(boolean flag) {
        this.player.setFullscreen(flag);
    }

    @Override
    public boolean isFullscreen() {
        return this.player.isFullscreen();
    }

    @Override
    public void setAutoFullscreenMode(boolean flag) {
        this.autoFsMode = flag;
    }

    @Override
    public void setEnableControls(boolean flag) {
        if (this.media.isAudioOnly) {
            return;
        }
        if (this.player != null) {
            if (flag) {
                this.player.enableControls();
            } else {
                this.player.disableControls();
            }
        } else {
            this.enableControls = flag;
        }
    }

    @Override
    public void show() {
        this.player.show();
    }

    @Override
    public void hide() {
        this.player.hide();
    }

    @Override
    public float getCurrentTime() {
        return (float)this.player.getCurrentPosition() / 1000.0f;
    }

    @Override
    public float getDuration() {
        return (float)this.player.getDuration() / 1000.0f;
    }

    @Override
    public boolean hasStarted() {
        return this._hasStarted;
    }

    @Override
    public boolean hasFinished() {
        return this._hasFinished;
    }

    @Override
    public void destroy() {
        this.destroyInternal();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.UNLOAD));
    }

    @Override
    public void changeOutput(SambaMedia.Output output) {
        int currentPosition = this.player.getCurrentPosition();
        for (SambaMedia.Output o : this.media.outputs) {
            o.current = o.label.equals(output.label);
        }
        this.media.url = output.url;
        this.destroyInternal();
        this.create(false);
        this.player.seek(currentPosition);
    }

    private void create() {
        this.create(true);
    }

    private void create(boolean notify) {
        if (this.player != null) {
            Log.e((String)"player", (String)"Player already created!");
            return;
        }
        if (this.media.url == null || this.media.url.isEmpty()) {
            Log.e((String)"player", (String)"Media data is null!");
            return;
        }
        Video.VideoType videoType = Video.VideoType.OTHER;
        switch (this.media.type.toLowerCase()) {
            case "hls": {
                videoType = Video.VideoType.HLS;
                break;
            }
            case "dash": {
                videoType = Video.VideoType.DASH;
            }
        }
        this.player = new SimpleVideoPlayer((Activity)this.view.getContext(), this.view, new Video(this.media.url, videoType), this.media.title, this.media.adUrl == null || this.media.adUrl.isEmpty(), this.media.isAudioOnly);
        this.player.setSeekbarColor(this.media.themeColor);
        this.player.moveSurfaceToBackground();
        if (this.media.isLive) {
            ((Activity)this.view.getContext()).findViewById(R.id.time_container).setVisibility(4);
            this.player.setControlsVisible(false, new String[]{"seekbar"});
            this.player.addActionButton(ContextCompat.getDrawable((Context)this.view.getContext(), (int)R.drawable.ic_live), this.view.getContext().getString(R.string.live), null);
        }
        this.player.addPlaybackListener(this.playbackListener);
        this.player.setPlayCallback(this.playListener);
        if (this.media.isAudioOnly) {
            this.player.setControlsVisible(true, new String[]{"play"});
            this.player.setControlsVisible(false, new String[]{"fullscreen", "playLarge", "topChrome"});
            this.player.setBackgroundColor(-12369085);
            this.player.setChromeColor(0);
        } else {
            this.player.setFullscreenCallback(this.fullscreenListener);
        }
        this.orientationEventListener = new OrientationEventListener(this.view.getContext()){
            {
                this.enable();
            }

            public void onOrientationChanged(int orientation) {
                if (Settings.System.getInt((ContentResolver)SambaPlayerController.this.view.getContext().getContentResolver(), (String)"accelerometer_rotation", (int)0) == 0 || !SambaPlayerController.this.autoFsMode || SambaPlayerController.this.player == null) {
                    return;
                }
                if (orientation <= 15 && orientation >= 0) {
                    if (SambaPlayerController.this.player.isFullscreen()) {
                        SambaPlayerController.this.player.setFullscreen(false);
                    }
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PORTRAIT));
                } else if (orientation >= 80 && orientation <= 100 || orientation >= 260 && orientation <= 290) {
                    if (!SambaPlayerController.this.player.isFullscreen()) {
                        SambaPlayerController.this.player.setFullscreen(true);
                    }
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LANDSCAPE));
                }
            }
        };
        if (notify) {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LOAD, this.view));
        }
        if (this.media.outputs != null && this.media.outputs.size() > 1 && !this.media.isAudioOnly) {
            this.outputMenu = ((Activity)this.view.getContext()).getLayoutInflater().inflate(R.layout.output_menu_layout, null);
            TextView cancelButton = (TextView)this.outputMenu.findViewById(R.id.output_menu_cancel_button);
            cancelButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SambaPlayerController.this.player.closeOutputMenu();
                }
            });
            OutputAdapter outputAdapter = new OutputAdapter(this.view.getContext(), this.media.outputs);
            ListView outputMenuList = (ListView)this.outputMenu.findViewById(R.id.output_menu_list);
            outputMenuList.setAdapter((ListAdapter)outputAdapter);
            outputMenuList.setOnItemClickListener(this.menuItemListener);
            outputAdapter.notifyDataSetChanged();
            this.player.setOutputMenu(this.outputMenu);
        }
        if (!this.enableControls && !this.media.isAudioOnly) {
            this.player.disableControls();
        }
    }

    private void destroyInternal() {
        if (this.player == null) {
            return;
        }
        this.stopProgressTimer();
        this.stop();
        if (this.outputMenu != null) {
            ((ListView)this.outputMenu.findViewById(R.id.output_menu_list)).setOnItemClickListener(null);
            this.outputMenu.findViewById(R.id.output_menu_cancel_button).setOnClickListener(null);
        }
        this.orientationEventListener.disable();
        this.player.setPlayCallback(null);
        this.player.setFullscreenCallback(null);
        this.player.release();
        this.outputMenu = null;
        this.orientationEventListener = null;
        this.player = null;
        this._hasStarted = false;
        this._hasFinished = false;
    }

    private void startProgressTimer() {
        if (this.progressTimer != null) {
            return;
        }
        this.progressTimer = new Timer();
        this.progressTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)SambaPlayerController.this.view.getContext()).runOnUiThread(SambaPlayerController.this.progressDispatcher);
            }
        }, 0L, 250L);
    }

    private void stopProgressTimer() {
        if (this.progressTimer == null) {
            return;
        }
        this.progressTimer.cancel();
        this.progressTimer.purge();
        this.progressTimer = null;
    }
}

