/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.offline;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import android.widget.Toast;
import com.google.android.exoplayer2.offline.ActionFile;
import com.google.android.exoplayer2.offline.DownloadAction;
import com.google.android.exoplayer2.offline.DownloadManager;
import com.google.android.exoplayer2.offline.DownloadService;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.util.Log;
import com.sambatech.player.SambaApi;
import com.sambatech.player.event.SambaApiCallback;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.model.SambaMediaRequest;
import com.sambatech.player.offline.OfflineUtils;
import com.sambatech.player.offline.SambaDownloadManager;
import com.sambatech.player.offline.SambaDownloadService;
import com.sambatech.player.offline.StartDownloadHelper;
import com.sambatech.player.offline.listeners.LicenceDrmCallback;
import com.sambatech.player.offline.listeners.SambaDownloadListener;
import com.sambatech.player.offline.listeners.SambaDownloadRequestListener;
import com.sambatech.player.offline.model.DownloadData;
import com.sambatech.player.offline.model.DownloadState;
import com.sambatech.player.offline.model.ProgressMessageEvent;
import com.sambatech.player.offline.model.SambaDownloadRequest;
import com.sambatech.player.offline.model.SambaSubtitle;
import com.sambatech.player.offline.model.SambaTrack;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.collections4.CollectionUtils;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class SambaDownloadTracker
implements DownloadManager.Listener {
    private static final String TAG = "SambaDownloadTracker";
    private final Context context;
    private final DataSource.Factory dataSourceFactory;
    private final CopyOnWriteArraySet<SambaDownloadListener> listeners;
    private final HashMap<Uri, DownloadAction> trackedDownloadStates;
    private List<SambaMediaConfig> sambaMedias;
    private final ActionFile actionFile;
    private final Handler actionFileWriteHandler;

    SambaDownloadTracker(Context context, DataSource.Factory dataSourceFactory, File actionFile, DownloadAction.Deserializer ... deserializers) {
        this.context = context.getApplicationContext();
        this.dataSourceFactory = dataSourceFactory;
        this.actionFile = new ActionFile(actionFile);
        this.listeners = new CopyOnWriteArraySet();
        this.trackedDownloadStates = new HashMap();
        this.sambaMedias = OfflineUtils.getPersistedSambaMedias();
        HandlerThread actionFileWriteThread = new HandlerThread(TAG);
        actionFileWriteThread.start();
        this.actionFileWriteHandler = new Handler(actionFileWriteThread.getLooper());
        this.loadTrackedActions(deserializers.length > 0 ? deserializers : DownloadAction.getDefaultDeserializers());
        EventBus.getDefault().register((Object)this);
    }

    void addListener(SambaDownloadListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(SambaDownloadListener listener) {
        this.listeners.remove(listener);
    }

    boolean isDownloaded(@NonNull String mediaId) {
        SambaMediaConfig sambaMediaConfig = (SambaMediaConfig)CollectionUtils.find(this.sambaMedias, media -> media.id.equals(mediaId));
        if (sambaMediaConfig != null) {
            Uri uri = Uri.parse((String)sambaMediaConfig.downloadUrl);
            return this.trackedDownloadStates.containsKey(uri);
        }
        return false;
    }

    boolean isDownloading(@NonNull String mediaId) {
        if (SambaDownloadManager.getInstance().getDownloadManager().getTaskCount() > 0) {
            DownloadManager.TaskState[] taskStates;
            for (DownloadManager.TaskState taskState : taskStates = SambaDownloadManager.getInstance().getDownloadManager().getAllTaskStates()) {
                DownloadData downloadData = OfflineUtils.getDownloadDataFromBytes(taskState.action.data);
                if (!downloadData.getMediaId().equals(mediaId)) continue;
                return true;
            }
        }
        return false;
    }

    void cancelAllDownloads() {
        if (SambaDownloadManager.getInstance().getDownloadManager().getTaskCount() > 0) {
            DownloadManager.TaskState[] taskStates;
            for (DownloadManager.TaskState taskState : taskStates = SambaDownloadManager.getInstance().getDownloadManager().getAllTaskStates()) {
                DownloadAction removeAction;
                DownloadData downloadData = OfflineUtils.getDownloadDataFromBytes(taskState.action.data);
                Uri uri = taskState.action.uri;
                if (downloadData.getSambaSubtitle() != null) {
                    removeAction = OfflineUtils.getDownloadHelper(uri, "progressive", this.dataSourceFactory).getRemoveAction(taskState.action.data);
                } else {
                    String extension = downloadData.getSambaMedia().type;
                    removeAction = OfflineUtils.getDownloadHelper(uri, extension, this.dataSourceFactory).getRemoveAction(taskState.action.data);
                }
                this.startServiceWithAction(removeAction);
            }
        }
    }

    void cancelDownload(String mediaId) {
        if (SambaDownloadManager.getInstance().getDownloadManager().getTaskCount() > 0) {
            DownloadManager.TaskState[] taskStates;
            for (DownloadManager.TaskState taskState : taskStates = SambaDownloadManager.getInstance().getDownloadManager().getAllTaskStates()) {
                DownloadAction removeAction;
                DownloadData downloadData = OfflineUtils.getDownloadDataFromBytes(taskState.action.data);
                if (!downloadData.getMediaId().equals(mediaId)) continue;
                Uri uri = taskState.action.uri;
                if (downloadData.getSambaSubtitle() != null) {
                    removeAction = OfflineUtils.getDownloadHelper(uri, "progressive", this.dataSourceFactory).getRemoveAction(taskState.action.data);
                } else {
                    String extension = downloadData.getSambaMedia().type;
                    removeAction = OfflineUtils.getDownloadHelper(uri, extension, this.dataSourceFactory).getRemoveAction(taskState.action.data);
                }
                this.startServiceWithAction(removeAction);
            }
        }
    }

    void deleteDownload(String mediaId) {
        SambaMediaConfig sambaMediaConfig;
        if (this.sambaMedias != null && !this.sambaMedias.isEmpty() && (sambaMediaConfig = (SambaMediaConfig)CollectionUtils.find(this.sambaMedias, item -> item.id.equals(mediaId))) != null) {
            byte[] downloadData = OfflineUtils.buildDownloadData(sambaMediaConfig.id, sambaMediaConfig.title, 0.0, sambaMediaConfig, null);
            Uri uri = Uri.parse((String)sambaMediaConfig.downloadUrl);
            String extension = sambaMediaConfig.type;
            DownloadAction removeAction = OfflineUtils.getDownloadHelper(uri, extension, this.dataSourceFactory).getRemoveAction(downloadData);
            this.startServiceWithAction(removeAction);
            if (sambaMediaConfig.captions != null && !sambaMediaConfig.captions.isEmpty()) {
                for (SambaMedia.Caption caption : sambaMediaConfig.captions) {
                    if (caption.url == null || caption.url.isEmpty() || caption.label == null) continue;
                    byte[] subtitleDownloadData = OfflineUtils.buildDownloadData(sambaMediaConfig.id, sambaMediaConfig.title, 0.0, sambaMediaConfig, new SambaSubtitle(caption.label, caption));
                    Uri uriSub = Uri.parse((String)caption.url);
                    DownloadAction subtitleRemoveAction = OfflineUtils.getDownloadHelper(uriSub, "progressive", this.dataSourceFactory).getRemoveAction(subtitleDownloadData);
                    this.startServiceWithAction(subtitleRemoveAction);
                }
            }
        }
    }

    void deleteAllDownloads() {
        if (this.sambaMedias != null && !this.sambaMedias.isEmpty()) {
            for (SambaMediaConfig sambaMedia : this.sambaMedias) {
                this.deleteDownload(sambaMedia.id);
            }
        }
    }

    List<StreamKey> getOfflineStreamKeys(Uri uri) {
        if (!this.trackedDownloadStates.containsKey(uri)) {
            return Collections.emptyList();
        }
        return this.trackedDownloadStates.get(uri).getKeys();
    }

    void prepareDownload(final @NonNull SambaDownloadRequest sambaDownloadRequest, final @NonNull SambaDownloadRequestListener requestListener) {
        SambaApi api = new SambaApi(SambaDownloadManager.getInstance().getAppInstance().getApplicationContext(), "");
        api.requestMedia(new SambaMediaRequest(sambaDownloadRequest.getProjectHash(), sambaDownloadRequest.getMediaId()), new SambaApiCallback(){

            @Override
            public void onMediaResponse(SambaMedia media) {
                final SambaMediaConfig sambaMediaConfig = (SambaMediaConfig)media;
                if (SambaDownloadTracker.this.isDownloading(sambaMediaConfig.id)) {
                    requestListener.onDownloadRequestFailed(new Error("Media is downloading"), "Media is downloading");
                } else if (SambaDownloadTracker.this.isDownloaded(sambaMediaConfig.id)) {
                    requestListener.onDownloadRequestFailed(new Error("Media already downloaded"), "Media already downloaded");
                } else {
                    sambaDownloadRequest.setSambaMedia(sambaMediaConfig);
                    if (sambaMediaConfig.drmRequest != null) {
                        if (sambaDownloadRequest.getDrmToken() != null && !sambaDownloadRequest.getDrmToken().isEmpty()) {
                            sambaMediaConfig.drmRequest.setToken(sambaDownloadRequest.getDrmToken());
                        }
                        OfflineUtils.getLicenseDrm(sambaMediaConfig, new LicenceDrmCallback(){

                            @Override
                            public void onLicencePrepared(byte[] licencePayload) {
                                sambaMediaConfig.drmRequest.setDrmOfflinePayload(Base64.encodeToString((byte[])licencePayload, (int)0));
                                StartDownloadHelper startDownloadHelper = new StartDownloadHelper(SambaDownloadTracker.this.context, SambaDownloadTracker.this.dataSourceFactory, sambaDownloadRequest, requestListener);
                                startDownloadHelper.start();
                            }

                            @Override
                            public void onLicenceError(Error error) {
                                requestListener.onDownloadRequestFailed(error, "Error to request DRM licence");
                            }
                        });
                    } else {
                        StartDownloadHelper startDownloadHelper = new StartDownloadHelper(SambaDownloadTracker.this.context, SambaDownloadTracker.this.dataSourceFactory, sambaDownloadRequest, requestListener);
                        startDownloadHelper.start();
                    }
                }
            }

            @Override
            public void onMediaResponseError(Exception e, SambaMediaRequest request) {
                requestListener.onDownloadRequestFailed(new Error(e), "Error to request SambaMedia");
            }
        });
    }

    void performDownload(@NonNull SambaDownloadRequest sambaDownloadRequest) {
        SambaMediaConfig sambaMediaConfig = (SambaMediaConfig)sambaDownloadRequest.getSambaMedia();
        if (this.isDownloading(sambaMediaConfig.id)) {
            Toast.makeText((Context)this.context, (CharSequence)"A Media j\u00e1 est\u00e1 sendo baixada", (int)0).show();
        } else if (this.isDownloaded(sambaMediaConfig.id)) {
            Toast.makeText((Context)this.context, (CharSequence)"Media j\u00e1 baixada", (int)0).show();
        } else if (OfflineUtils.isValidRequest(sambaDownloadRequest)) {
            this.startDownload(sambaDownloadRequest);
        }
    }

    public void onInitialized(DownloadManager downloadManager) {
    }

    public void onTaskStateChanged(DownloadManager downloadManager, DownloadManager.TaskState taskState) {
        SambaMediaConfig sambaMediaConfig;
        DownloadData downloadData;
        DownloadAction action = taskState.action;
        Uri uri = action.uri;
        DownloadState.State state = null;
        if (action.isRemoveAction && taskState.state == 2 || !action.isRemoveAction && taskState.state == 4) {
            if (this.trackedDownloadStates.remove(uri) != null) {
                this.handleTrackedDownloadStatesChanged();
                downloadData = OfflineUtils.getDownloadDataFromBytes(action.data);
                sambaMediaConfig = (SambaMediaConfig)CollectionUtils.find(this.sambaMedias, item -> item.id.equals(downloadData.getMediaId()));
                if (sambaMediaConfig != null && this.sambaMedias.remove(sambaMediaConfig)) {
                    OfflineUtils.persistSambaMedias(this.sambaMedias);
                }
            }
            state = !action.isRemoveAction ? DownloadState.State.FAILED : DownloadState.State.DELETED;
        } else if (taskState.state == 2) {
            downloadData = OfflineUtils.getDownloadDataFromBytes(taskState.action.data);
            sambaMediaConfig = downloadData.getSambaMedia();
            sambaMediaConfig.isOffline = true;
            sambaMediaConfig.isSubtitlesOffline = downloadData.getSambaSubtitle() != null;
            SambaMediaConfig oldSambaMedia = (SambaMediaConfig)CollectionUtils.find(this.sambaMedias, item -> item.id.equals(sambaMediaConfig.id));
            if (oldSambaMedia != null) {
                int position = this.sambaMedias.indexOf(oldSambaMedia);
                this.sambaMedias.set(position, sambaMediaConfig);
            } else {
                this.sambaMedias.add(sambaMediaConfig);
            }
            OfflineUtils.persistSambaMedias(this.sambaMedias);
        }
        DownloadState downloadState = OfflineUtils.buildDownloadState(taskState, state);
        for (SambaDownloadListener listener : this.listeners) {
            listener.onDownloadStateChanged(downloadState);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onProgressMessageReceived(ProgressMessageEvent progressMessageEvent) {
        DownloadState downloadState = OfflineUtils.buildDownloadState(progressMessageEvent.getTaskState(), null);
        for (SambaDownloadListener listener : this.listeners) {
            listener.onDownloadStateChanged(downloadState);
        }
    }

    public void onIdle(DownloadManager downloadManager) {
    }

    private void loadTrackedActions(DownloadAction.Deserializer[] deserializers) {
        try {
            DownloadAction[] allActions;
            for (DownloadAction action : allActions = this.actionFile.load(deserializers)) {
                this.trackedDownloadStates.put(action.uri, action);
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to load tracked actions", (Throwable)e);
        }
    }

    private void handleTrackedDownloadStatesChanged() {
        DownloadAction[] actions = this.trackedDownloadStates.values().toArray(new DownloadAction[0]);
        this.actionFileWriteHandler.post(() -> {
            try {
                this.actionFile.store(actions);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Failed to store tracked actions", (Throwable)e);
            }
        });
    }

    private void startDownload(SambaDownloadRequest sambaDownloadRequest) {
        List<SambaTrack> finalTracks = OfflineUtils.buildFinalTracks(sambaDownloadRequest);
        ArrayList trackKeys = new ArrayList(CollectionUtils.collect(finalTracks, input -> input.getTrackKey()));
        Double totalDownloadSize = OfflineUtils.buildDownloadSize(finalTracks);
        SambaMediaConfig sambaMediaConfig = (SambaMediaConfig)sambaDownloadRequest.getSambaMedia();
        byte[] downloadData = OfflineUtils.buildDownloadData(sambaMediaConfig.id, sambaMediaConfig.title, totalDownloadSize, (SambaMediaConfig)sambaDownloadRequest.getSambaMedia(), null);
        DownloadAction downloadAction = sambaDownloadRequest.getDownloadHelper().getDownloadAction(downloadData, trackKeys);
        if (this.trackedDownloadStates.containsKey(downloadAction.uri)) {
            return;
        }
        this.trackedDownloadStates.put(downloadAction.uri, downloadAction);
        this.handleTrackedDownloadStatesChanged();
        this.startServiceWithAction(downloadAction);
        if (sambaDownloadRequest.getSambaSubtitlesForDownload() != null && !sambaDownloadRequest.getSambaSubtitlesForDownload().isEmpty()) {
            List<DownloadAction> captionsDownloadActions = OfflineUtils.buildCaptionsDownloadActions(sambaDownloadRequest.getSambaSubtitlesForDownload(), (SambaMediaConfig)sambaDownloadRequest.getSambaMedia(), this.dataSourceFactory);
            for (DownloadAction captionsDownloadAction : captionsDownloadActions) {
                this.trackedDownloadStates.put(captionsDownloadAction.uri, downloadAction);
                this.handleTrackedDownloadStatesChanged();
                this.startServiceWithAction(captionsDownloadAction);
            }
        }
    }

    private void startServiceWithAction(DownloadAction action) {
        DownloadService.startWithAction((Context)this.context, SambaDownloadService.class, (DownloadAction)action, (boolean)false);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        EventBus.getDefault().unregister((Object)this);
    }

    void startStoppedDownloads() {
        if (SambaDownloadManager.getInstance().getDownloadManager().getTaskCount() > 0) {
            DownloadManager.TaskState[] taskStates;
            for (DownloadManager.TaskState taskState : taskStates = SambaDownloadManager.getInstance().getDownloadManager().getAllTaskStates()) {
                this.startServiceWithAction(taskState.action);
            }
        }
    }

    void stopAllDownloads() {
        SambaDownloadManager.getInstance().getDownloadManager().stopDownloads();
    }

    @Nullable
    SambaMedia getDownloadedMedia(@NonNull String mediaId) {
        if (this.sambaMedias != null && !this.sambaMedias.isEmpty()) {
            return (SambaMedia)CollectionUtils.find(this.sambaMedias, item -> item.id.equals(mediaId));
        }
        return null;
    }

    List<SambaMedia> getDownloadedMedias() {
        return new ArrayList<SambaMedia>(CollectionUtils.collect(this.sambaMedias, input -> input));
    }

    void updateDownloadedMedia(SambaMedia sambaMedia) {
        SambaMediaConfig newSambaMediaConfig;
        SambaMediaConfig oldSambaMediaConfig;
        if (this.sambaMedias != null && !this.sambaMedias.isEmpty() && (oldSambaMediaConfig = (SambaMediaConfig)CollectionUtils.find(this.sambaMedias, arg_0 -> SambaDownloadTracker.lambda$updateDownloadedMedia$8(newSambaMediaConfig = (SambaMediaConfig)sambaMedia, arg_0))) != null) {
            int position = this.sambaMedias.indexOf(oldSambaMediaConfig);
            this.sambaMedias.set(position, newSambaMediaConfig);
            OfflineUtils.persistSambaMedias(this.sambaMedias);
        }
    }

    private static /* synthetic */ boolean lambda$updateDownloadedMedia$8(SambaMediaConfig newSambaMediaConfig, SambaMediaConfig item) {
        return item.id.equals(newSambaMediaConfig.id);
    }
}

