/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.mediasource;

import android.net.Uri;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.hls.playlist.HlsPlaylistParserFactory;
import com.peer5.sdk.Peer5Sdk;
import com.sambatech.player.mediasource.PlayerInstanceDefault;
import com.sambatech.player.mediasource.PlayerMediaSource;
import com.sambatech.player.mediasource.PlayerMediaSourceInterface;
import com.sambatech.player.offline.SambaDownloadManager;

public class PlayerMediaSourceHLS
extends PlayerMediaSource
implements PlayerMediaSourceInterface {
    public PlayerMediaSourceHLS(PlayerInstanceDefault playerInstanceDefault, String url, Boolean enablePeer5, boolean isLive) {
        super(playerInstanceDefault);
        this.setEnablePeer5(enablePeer5);
        this.setIsLive(isLive);
        this.setUrl(url);
    }

    @Override
    public void setUrl(String url) {
        super.setUrl(url);
        Uri uri = Uri.parse((String)url);
        boolean hasDrm = url.contains("/vodd-sd/");
        if (this.getEnablePeer5().booleanValue() && !hasDrm) {
            Uri peer5Uri;
            String peer5Url = Peer5Sdk.getPeer5StreamUrl((String)url);
            uri = peer5Uri = Uri.parse((String)peer5Url);
        }
        HlsMediaSource mediaSource = this.getIsLive() == false && SambaDownloadManager.getInstance().isConfigured() ? new HlsMediaSource.Factory(SambaDownloadManager.getInstance().buildDataSourceFactory()).setPlaylistParserFactory((HlsPlaylistParserFactory)new DefaultHlsPlaylistParserFactory(SambaDownloadManager.getInstance().getOfflineStreamKeys(uri))).createMediaSource(uri) : new HlsMediaSource.Factory(this.playerInstanceDefault.mediaDataSourceFactory).createMediaSource(uri);
        this.setMediaSource((MediaSource)mediaSource);
    }

    @Override
    public void destroy() {
        super.destroy();
    }
}

