/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.offline;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import com.google.android.exoplayer2.offline.DownloadManager;
import com.google.android.exoplayer2.offline.DownloadService;
import com.google.android.exoplayer2.scheduler.PlatformScheduler;
import com.google.android.exoplayer2.ui.DownloadNotificationUtil;
import com.google.android.exoplayer2.util.NotificationUtil;
import com.google.android.exoplayer2.util.Util;
import com.sambatech.player.R;
import com.sambatech.player.offline.OfflineUtils;
import com.sambatech.player.offline.SambaDownloadManager;
import com.sambatech.player.offline.model.DownloadData;
import com.sambatech.player.offline.model.ProgressMessageEvent;
import org.greenrobot.eventbus.EventBus;

public class SambaDownloadService
extends DownloadService {
    private static final String CHANNEL_ID = "download_channel";
    private static final int JOB_ID = 1;
    private static final int FOREGROUND_NOTIFICATION_ID = 1;

    public SambaDownloadService() {
        super(1, 1000L, CHANNEL_ID, R.string.exo_download_notification_channel_name);
    }

    protected DownloadManager getDownloadManager() {
        return SambaDownloadManager.getInstance().getDownloadManager();
    }

    protected PlatformScheduler getScheduler() {
        return Util.SDK_INT >= 21 ? new PlatformScheduler((Context)this, 1) : null;
    }

    protected Notification getForegroundNotification(DownloadManager.TaskState[] taskStates) {
        PendingIntent pedingintent;
        if (taskStates[0].state == 1) {
            ProgressMessageEvent progressMessageEvent = new ProgressMessageEvent(taskStates[0]);
            EventBus.getDefault().post((Object)progressMessageEvent);
        }
        if ((pedingintent = SambaDownloadManager.getInstance().getPendingIntentForDownloadNotifications()) == null) {
            PackageManager manager = SambaDownloadManager.getInstance().getAppInstance().getApplicationContext().getPackageManager();
            Intent intent = manager.getLaunchIntentForPackage(SambaDownloadManager.getInstance().getAppInstance().getApplicationContext().getPackageName());
            pedingintent = PendingIntent.getActivity((Context)SambaDownloadManager.getInstance().getAppInstance().getApplicationContext(), (int)0, (Intent)intent, (int)0);
        }
        return DownloadNotificationUtil.buildProgressNotification((Context)this, (int)R.drawable.exo_controls_play, (String)CHANNEL_ID, (PendingIntent)pedingintent, (String)OfflineUtils.buildNotificationProgressMessage(taskStates[0]), (DownloadManager.TaskState[])taskStates);
    }

    protected void onTaskStateChanged(DownloadManager.TaskState taskState) {
        if (taskState.action.isRemoveAction) {
            return;
        }
        PendingIntent pedingintent = SambaDownloadManager.getInstance().getPendingIntentForDownloadNotifications();
        if (pedingintent == null) {
            PackageManager manager = SambaDownloadManager.getInstance().getAppInstance().getApplicationContext().getPackageManager();
            Intent intent = manager.getLaunchIntentForPackage(SambaDownloadManager.getInstance().getAppInstance().getApplicationContext().getPackageName());
            pedingintent = PendingIntent.getActivity((Context)SambaDownloadManager.getInstance().getAppInstance().getApplicationContext(), (int)0, (Intent)intent, (int)0);
        }
        DownloadData downloadData = OfflineUtils.getDownloadDataFromBytes(taskState.action.data);
        String message = "";
        if (downloadData != null) {
            String string2 = message = downloadData.getMediaTitle() != null ? downloadData.getMediaTitle() : "";
            if (downloadData.getSambaSubtitle() != null) {
                message = message + (downloadData.getSambaSubtitle().getTitle() != null ? "\n\nLegenda: " + downloadData.getSambaSubtitle().getTitle() : "");
            }
        }
        Notification notification = null;
        if (taskState.state == 2) {
            notification = DownloadNotificationUtil.buildDownloadCompletedNotification((Context)this, (int)R.drawable.exo_controls_play, (String)CHANNEL_ID, (PendingIntent)pedingintent, (String)message);
        } else if (taskState.state == 4) {
            notification = DownloadNotificationUtil.buildDownloadFailedNotification((Context)this, (int)R.drawable.exo_controls_play, (String)CHANNEL_ID, (PendingIntent)pedingintent, (String)message);
        }
        int notificationId = 2 + taskState.taskId;
        NotificationUtil.setNotification((Context)this, (int)notificationId, (Notification)notification);
    }
}

