/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.model;

import android.support.annotation.NonNull;

public class SambaMediaRequest {
    public String projectHash;
    public String mediaId;
    public String liveChannelId;
    public String streamName;
    public String streamUrl;
    public boolean isStreamAudio;
    @NonNull
    public String[] backupUrls = new String[0];
    @NonNull
    public Environment environment = Environment.PROD;
    @NonNull
    public Protocol protocol = Protocol.HTTPS;

    public SambaMediaRequest(String projectHash, String mediaId) {
        this(projectHash, mediaId, false);
    }

    public SambaMediaRequest(String projectHash, String mediaIdOrLiveChannelId, boolean isLive) {
        this.projectHash = projectHash;
        if (isLive) {
            this.liveChannelId = mediaIdOrLiveChannelId;
        } else {
            this.mediaId = mediaIdOrLiveChannelId;
        }
    }

    public SambaMediaRequest(String projectHash, String mediaId, String streamName) {
        this(projectHash, mediaId, streamName, null);
    }

    public SambaMediaRequest(String projectHash, String mediaId, String streamName, String streamUrl) {
        this(projectHash, mediaId, streamName, streamUrl, null);
    }

    public SambaMediaRequest(String projectHash, String mediaId, String streamName, String streamUrl, String[] backupUrls) {
        this(projectHash, mediaId, streamName, streamUrl, backupUrls, false);
    }

    public SambaMediaRequest(String projectHash, String mediaId, String streamName, String streamUrl, String[] backupUrls, boolean isStreamAudio) {
        this.projectHash = projectHash;
        this.mediaId = mediaId;
        this.streamName = streamName;
        this.streamUrl = streamUrl;
        this.backupUrls = backupUrls != null ? backupUrls : new String[]{};
        this.isStreamAudio = isStreamAudio;
    }

    public String toString() {
        return String.format("projectHash: %s, id: %s, streamName: %s, streamUrls: %s, backupUrls (count): %s", this.projectHash, this.mediaId, this.streamName, this.streamUrl, this.backupUrls.length);
    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }

    public static enum Environment {
        LOCAL("localhost-8080"),
        DEV("web4-7091"),
        STAGING("staging"),
        PROD("prod");

        private final String value;

        private Environment(String value) {
            this.value = value;
        }

        public static Environment stringToEnvironment(String string2) {
            try {
                return Environment.valueOf(string2);
            }
            catch (Exception ex) {
                return PROD;
            }
        }

        public String toString() {
            return this.value;
        }
    }
}

