/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.mediasource;

import android.content.Context;
import android.os.Handler;
import android.util.Base64;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.FrameworkMediaDrm;
import com.google.android.exoplayer2.drm.HttpMediaDrmCallback;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.UnsupportedDrmException;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.offline.SambaDownloadManager;
import java.util.UUID;

public class PlayerInstanceDefault {
    Handler mainHandler;
    BandwidthMeter bandwidthMeter;
    AdaptiveTrackSelection.Factory adaptiveTrackSelectionFactory;
    DefaultTrackSelector trackSelector;
    private DefaultRenderersFactory renderersFactory;
    Context context;
    DataSource.Factory mediaDataSourceFactory;
    private DefaultDrmSessionManager drmSessionManager;
    private FrameworkMediaDrm mediaDrm;

    public PlayerInstanceDefault(Context context, SambaMediaConfig media) {
        boolean isDRM = media.drmRequest != null;
        this.context = context;
        this.mainHandler = new Handler();
        this.bandwidthMeter = new DefaultBandwidthMeter();
        this.adaptiveTrackSelectionFactory = new AdaptiveTrackSelection.Factory(this.bandwidthMeter);
        this.trackSelector = new DefaultTrackSelector((TrackSelection.Factory)this.adaptiveTrackSelectionFactory);
        if (isDRM) {
            try {
                this.drmSessionManager = media.isOffline ? this.buildOfflineDrmSessionManager(media) : this.buildOnlineDrmSessionManager(media);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.renderersFactory = new DefaultRenderersFactory(this.context);
        this.mediaDataSourceFactory = new DefaultDataSourceFactory(this.context, Util.getUserAgent((Context)this.context, (String)"mediaPlayerSample"), (TransferListener)this.bandwidthMeter);
    }

    private DefaultDrmSessionManager buildOnlineDrmSessionManager(SambaMediaConfig media) throws UnsupportedDrmException {
        String userAgent = SambaDownloadManager.getInstance().isConfigured() ? SambaDownloadManager.getInstance().getUserAgent() : Util.getUserAgent((Context)this.context.getApplicationContext(), (String)"SambaPlayer");
        return new DefaultDrmSessionManager(C.WIDEVINE_UUID, (ExoMediaDrm)FrameworkMediaDrm.newInstance((UUID)C.WIDEVINE_UUID), (MediaDrmCallback)new HttpMediaDrmCallback(media.drmRequest.getLicenseUrl(), (HttpDataSource.Factory)new DefaultHttpDataSourceFactory(userAgent)), null);
    }

    private DefaultDrmSessionManager buildOfflineDrmSessionManager(SambaMediaConfig media) throws UnsupportedDrmException {
        DefaultDrmSessionManager drmSessionManager = null;
        String offlineAssetKeyIdStr = media.drmRequest.getDrmOfflinePayload();
        this.mediaDrm = FrameworkMediaDrm.newInstance((UUID)C.WIDEVINE_UUID);
        if (offlineAssetKeyIdStr != null && !offlineAssetKeyIdStr.isEmpty()) {
            drmSessionManager = new DefaultDrmSessionManager(C.WIDEVINE_UUID, (ExoMediaDrm)this.mediaDrm, (MediaDrmCallback)new HttpMediaDrmCallback(media.drmRequest.getLicenseUrl(), (HttpDataSource.Factory)new DefaultHttpDataSourceFactory(SambaDownloadManager.getInstance().getUserAgent())), null);
            byte[] offlineAssetKeyId = Base64.decode((String)offlineAssetKeyIdStr, (int)0);
            drmSessionManager.setMode(1, offlineAssetKeyId);
        }
        return drmSessionManager;
    }

    public SimpleExoPlayer createPlayerInstance() {
        return ExoPlayerFactory.newSimpleInstance((Context)this.context, (RenderersFactory)this.renderersFactory, (TrackSelector)this.trackSelector, (DrmSessionManager)this.drmSessionManager);
    }

    public void destroy() {
        this.mainHandler = null;
        this.bandwidthMeter = null;
        this.adaptiveTrackSelectionFactory = null;
        this.trackSelector = null;
        this.renderersFactory = null;
        this.mediaDataSourceFactory = null;
        if (this.mediaDrm != null) {
            this.mediaDrm.release();
        }
        this.drmSessionManager = null;
    }
}

