/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.offline;

import android.net.Uri;
import android.os.AsyncTask;
import android.util.Pair;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.OfflineLicenseHelper;
import com.google.android.exoplayer2.offline.DownloadAction;
import com.google.android.exoplayer2.offline.DownloadHelper;
import com.google.android.exoplayer2.offline.DownloadManager;
import com.google.android.exoplayer2.offline.ProgressiveDownloadHelper;
import com.google.android.exoplayer2.source.dash.DashUtil;
import com.google.android.exoplayer2.source.dash.manifest.DashManifest;
import com.google.android.exoplayer2.source.dash.manifest.Period;
import com.google.android.exoplayer2.source.dash.offline.DashDownloadHelper;
import com.google.android.exoplayer2.source.hls.offline.HlsDownloadHelper;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.offline.SambaDownloadManager;
import com.sambatech.player.offline.listeners.LicenceDrmCallback;
import com.sambatech.player.offline.model.DownloadData;
import com.sambatech.player.offline.model.DownloadState;
import com.sambatech.player.offline.model.SambaDownloadRequest;
import com.sambatech.player.offline.model.SambaSubtitle;
import com.sambatech.player.offline.model.SambaTrack;
import com.sambatech.player.utils.SharedPrefsUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

class OfflineUtils {
    private static final String MEDIAS_PERSISTED_KEY = "MEDIAS_PERSISTED_KEY";

    private OfflineUtils() {
        throw new IllegalArgumentException("Static class");
    }

    static void getLicenseDrm(SambaMediaConfig sambaMediaConfig, final LicenceDrmCallback drmCallback) {
        if (sambaMediaConfig.drmRequest == null) {
            drmCallback.onLicenceError(new Error("Media without DRM datas"));
            return;
        }
        AsyncTask<SambaMediaConfig, String, Pair<byte[], Exception>> task = new AsyncTask<SambaMediaConfig, String, Pair<byte[], Exception>>(){

            protected Pair<byte[], Exception> doInBackground(SambaMediaConfig ... datas) {
                Pair pairResponse;
                SambaMediaConfig sambaMediaConfig = datas[0];
                try {
                    Uri uri = Uri.parse((String)sambaMediaConfig.url);
                    String licenseUrl = sambaMediaConfig.drmRequest.getLicenseUrl();
                    DefaultHttpDataSourceFactory httpDataSourceFactory = new DefaultHttpDataSourceFactory(SambaDownloadManager.getInstance().getUserAgent());
                    OfflineLicenseHelper offlineLicenseHelper = OfflineLicenseHelper.newWidevineInstance((String)licenseUrl, (HttpDataSource.Factory)httpDataSourceFactory);
                    HttpDataSource dataSource = httpDataSourceFactory.createDataSource();
                    DashManifest dashManifest = DashUtil.loadManifest((DataSource)dataSource, (Uri)uri);
                    DrmInitData drmInitData = DashUtil.loadDrmInitData((DataSource)dataSource, (Period)dashManifest.getPeriod(0));
                    byte[] offlineAssetKeyId = offlineLicenseHelper.downloadLicense(drmInitData);
                    pairResponse = new Pair((Object)offlineAssetKeyId, null);
                }
                catch (Exception e) {
                    pairResponse = new Pair(null, (Object)e);
                }
                return pairResponse;
            }

            protected void onPostExecute(Pair<byte[], Exception> pairResponse) {
                if (pairResponse.second != null) {
                    drmCallback.onLicenceError(new Error((Throwable)pairResponse.second));
                    return;
                }
                drmCallback.onLicencePrepared((byte[])pairResponse.first);
            }
        };
        task.execute((Object[])new SambaMediaConfig[]{sambaMediaConfig});
    }

    static void persistSambaMedias(List<SambaMediaConfig> sambaMediaConfigList) {
        Type listType = new TypeToken<List<SambaMediaConfig>>(){}.getType();
        Gson gson = new Gson();
        String json = gson.toJson(sambaMediaConfigList, listType);
        SharedPrefsUtils.setStringPreference(SambaDownloadManager.getInstance().getAppInstance().getApplicationContext(), MEDIAS_PERSISTED_KEY, json);
    }

    static List<SambaMediaConfig> getPersistedSambaMedias() {
        String json = SharedPrefsUtils.getStringPreference(SambaDownloadManager.getInstance().getAppInstance().getApplicationContext(), MEDIAS_PERSISTED_KEY);
        if (json == null || json.isEmpty()) {
            return new ArrayList<SambaMediaConfig>();
        }
        Type listType = new TypeToken<List<SambaMediaConfig>>(){}.getType();
        Gson gson = new Gson();
        return (List)gson.fromJson(json, listType);
    }

    static int inferPrimaryTrackType(Format format) {
        int trackType = MimeTypes.getTrackType((String)format.sampleMimeType);
        if (trackType != -1) {
            return trackType;
        }
        if (MimeTypes.getVideoMediaMimeType((String)format.codecs) != null) {
            return 2;
        }
        if (MimeTypes.getAudioMediaMimeType((String)format.codecs) != null) {
            return 1;
        }
        if (format.width != -1 || format.height != -1) {
            return 2;
        }
        if (format.channelCount != -1 || format.sampleRate != -1) {
            return 1;
        }
        return -1;
    }

    static Double getSizeInMB(long bitrate, long duration) {
        return (float)bitrate / 1000000.0f * (float)duration / 8.0f;
    }

    static byte[] buildDownloadData(String mediaId, String mediaTitle, Double totalDownload, SambaMediaConfig sambaMedia, SambaSubtitle sambaSubtitle) {
        DownloadData downloadData = new DownloadData(mediaId, mediaTitle, totalDownload, sambaMedia);
        downloadData.setSambaSubtitle(sambaSubtitle);
        String json = new Gson().toJson((Object)downloadData, DownloadData.class);
        return Util.getUtf8Bytes((String)json);
    }

    static DownloadData getDownloadDataFromBytes(byte[] data) {
        String json = Util.fromUtf8Bytes((byte[])data);
        return (DownloadData)new Gson().fromJson(json, DownloadData.class);
    }

    static Double buildDownloadSize(List<SambaTrack> finalTracks) {
        Double totalSize = 0.0;
        for (SambaTrack finalTrack : finalTracks) {
            totalSize = totalSize + finalTrack.getSizeInMB();
        }
        return totalSize;
    }

    static List<SambaTrack> buildFinalTracks(SambaDownloadRequest sambaDownloadRequest) {
        List<SambaTrack> selectedTracks = sambaDownloadRequest.getSambaTracksForDownload();
        List<SambaTrack> audioTracks = sambaDownloadRequest.getSambaAudioTracks();
        if (selectedTracks != null && !selectedTracks.isEmpty()) {
            if (audioTracks != null && !audioTracks.isEmpty()) {
                for (SambaTrack audioTrack : audioTracks) {
                    if (selectedTracks.contains(audioTrack)) continue;
                    selectedTracks.add(audioTrack);
                }
            }
        } else {
            selectedTracks = new ArrayList<SambaTrack>();
        }
        return selectedTracks;
    }

    static boolean isValidRequest(SambaDownloadRequest sambaDownloadRequest) {
        return sambaDownloadRequest.getDownloadHelper() != null && sambaDownloadRequest.getSambaMedia() != null && sambaDownloadRequest.getSambaTracksForDownload() != null && !sambaDownloadRequest.getSambaTracksForDownload().isEmpty();
    }

    static DownloadState buildDownloadState(DownloadManager.TaskState taskState, DownloadState.State optionalState) {
        DownloadState.State state;
        DownloadData downloadData = OfflineUtils.getDownloadDataFromBytes(taskState.action.data);
        if (optionalState != null) {
            state = optionalState;
        } else {
            switch (taskState.state) {
                case 0: {
                    state = DownloadState.State.WAITING;
                    break;
                }
                case 1: {
                    state = DownloadState.State.IN_PROGRESS;
                    break;
                }
                case 3: {
                    state = DownloadState.State.CANCELED;
                    break;
                }
                case 2: {
                    state = DownloadState.State.COMPLETED;
                    break;
                }
                default: {
                    state = DownloadState.State.FAILED;
                }
            }
        }
        return new DownloadState(taskState.downloadPercentage, downloadData, state);
    }

    static DownloadHelper getDownloadHelper(Uri uri, String extension, DataSource.Factory dataSourceFactory) {
        switch (extension.toLowerCase()) {
            case "dash": {
                return new DashDownloadHelper(uri, dataSourceFactory);
            }
            case "hls": {
                return new HlsDownloadHelper(uri, dataSourceFactory);
            }
        }
        return new ProgressiveDownloadHelper(uri);
    }

    static List<DownloadAction> buildCaptionsDownloadActions(List<SambaSubtitle> subtitles, SambaMediaConfig sambaMediaConfig, DataSource.Factory dataSourceFactory) {
        ArrayList<DownloadAction> downloadActions = new ArrayList<DownloadAction>();
        for (SambaSubtitle subtitle : subtitles) {
            if (subtitle.getCaption().url == null || subtitle.getCaption().url.isEmpty() || subtitle.getCaption().label == null) continue;
            byte[] downloadData = OfflineUtils.buildDownloadData(sambaMediaConfig.id, sambaMediaConfig.title, 0.0, sambaMediaConfig, subtitle);
            DownloadAction downloadAction = OfflineUtils.getDownloadHelper(Uri.parse((String)subtitle.getCaption().url), "progressive", dataSourceFactory).getDownloadAction(downloadData, new ArrayList());
            downloadActions.add(downloadAction);
        }
        return downloadActions;
    }

    static String buildNotificationProgressMessage(DownloadManager.TaskState taskState) {
        StringBuilder stringBuilder = new StringBuilder();
        DownloadData downloadData = null;
        if (taskState.action.data != null) {
            downloadData = OfflineUtils.getDownloadDataFromBytes(taskState.action.data);
        }
        if (taskState.action.isRemoveAction) {
            if (downloadData != null) {
                if (downloadData.getMediaTitle() != null && !downloadData.getMediaTitle().isEmpty()) {
                    stringBuilder.append(downloadData.getMediaTitle());
                }
                if (downloadData.getSambaSubtitle() != null) {
                    stringBuilder.append("\n\nLegenda: " + downloadData.getSambaSubtitle().getTitle());
                }
            }
        } else if (downloadData != null && downloadData.getSambaSubtitle() != null) {
            if (downloadData.getMediaTitle() != null && !downloadData.getMediaTitle().isEmpty()) {
                stringBuilder.append(downloadData.getMediaTitle());
            }
            stringBuilder.append("\n\nLegenda: " + downloadData.getSambaSubtitle().getTitle());
        } else {
            float downloadPercentage = taskState.downloadPercentage >= 0.0f ? taskState.downloadPercentage : 0.0f;
            Double downloadedMegaBytes = taskState.downloadedBytes > 0L ? (double)(taskState.downloadedBytes / 1024L / 1024L) : 0.0;
            stringBuilder.append(String.format("%.1f%%", Float.valueOf(downloadPercentage)));
            if (downloadData != null) {
                if (downloadData.getTotalDownloadSizeInMB() != null && downloadData.getTotalDownloadSizeInMB() > 0.0) {
                    stringBuilder.append(String.format(" - %.1f MB de %.1f MB", downloadedMegaBytes, downloadData.getTotalDownloadSizeInMB()));
                }
                if (downloadData.getMediaTitle() != null && !downloadData.getMediaTitle().isEmpty()) {
                    stringBuilder.append("\n\n");
                    stringBuilder.append(downloadData.getMediaTitle());
                }
            }
        }
        return stringBuilder.toString();
    }
}

