/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.utils;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.sambatech.player.R;
import com.sambatech.player.utils.OptionsMenuController;

public class OptionsMenuLayer
extends FrameLayout
implements View.OnClickListener,
OptionsMenuController {
    private LinearLayout hdButton;
    private LinearLayout captionsButton;
    private LinearLayout speedButton;
    private ImageButton closeButton;
    private ViewGroup parentView;
    private OptionsMenuCallback callback;

    public OptionsMenuLayer(Context context, ViewGroup parentView) {
        this(context, parentView, null);
    }

    public OptionsMenuLayer(Context context, ViewGroup parentView, AttributeSet attrs) {
        this(context, parentView, attrs, 0);
    }

    public OptionsMenuLayer(Context context, ViewGroup parentView, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.menu_options_layer, (ViewGroup)this);
        this.parentView = parentView;
        this.hdButton = (LinearLayout)this.findViewById(R.id.quality_button);
        this.captionsButton = (LinearLayout)this.findViewById(R.id.subtitle_button);
        this.speedButton = (LinearLayout)this.findViewById(R.id.speed_button);
        this.closeButton = (ImageButton)this.findViewById(R.id.close_menu_button);
        this.hdButton.setOnClickListener((View.OnClickListener)this);
        this.captionsButton.setOnClickListener((View.OnClickListener)this);
        this.speedButton.setOnClickListener((View.OnClickListener)this);
        this.closeButton.setOnClickListener((View.OnClickListener)this);
        this.setVisibility(8);
    }

    public void onClick(View v) {
        if (this.callback == null) {
            return;
        }
        int i = v.getId();
        if (i == R.id.quality_button) {
            this.callback.onTouchHD();
        } else if (i == R.id.subtitle_button) {
            this.callback.onTouchCaptions();
        } else if (i == R.id.speed_button) {
            this.callback.onTouchSpeed();
        } else if (i == R.id.close_menu_button) {
            this.hideMenu();
            this.callback.onMenuDismiss();
        }
    }

    @Override
    public void setHdButtonVisibility(Boolean visibility) {
        if (this.hdButton == null) {
            return;
        }
        this.hdButton.setVisibility(visibility != false ? 0 : 8);
    }

    @Override
    public void setCaptionsButtonVisibility(Boolean visibility) {
        if (this.captionsButton == null) {
            return;
        }
        this.captionsButton.setVisibility(visibility != false ? 0 : 8);
    }

    @Override
    public void setSpeedButtonVisibility(Boolean visibility) {
        if (this.speedButton == null) {
            return;
        }
        this.speedButton.setVisibility(visibility != false ? 0 : 8);
    }

    @Override
    public void showMenu() {
        this.setVisibility(0);
        this.bringToFront();
    }

    @Override
    public void hideMenu() {
        this.setVisibility(8);
    }

    @Override
    public OptionsMenuCallback getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(OptionsMenuCallback callback) {
        this.callback = callback;
    }

    @Override
    public void bringToFront() {
        this.parentView.bringChildToFront((View)this);
    }

    @Override
    public boolean isVisible() {
        return this.getVisibility() == 0;
    }

    public static interface OptionsMenuCallback {
        public void onTouchHD();

        public void onTouchCaptions();

        public void onTouchSpeed();

        public void onMenuDismiss();
    }
}

