/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.offline;

import android.app.Application;
import android.app.PendingIntent;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.exoplayer2.offline.DownloadAction;
import com.google.android.exoplayer2.offline.DownloadManager;
import com.google.android.exoplayer2.offline.DownloaderConstructorHelper;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSourceFactory;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.NoOpCacheEvictor;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import com.google.android.exoplayer2.util.Util;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.offline.SambaDownloadTracker;
import com.sambatech.player.offline.listeners.SambaDownloadListener;
import com.sambatech.player.offline.listeners.SambaDownloadRequestListener;
import com.sambatech.player.offline.model.SambaDownloadRequest;
import java.io.File;
import java.util.List;

public class SambaDownloadManager {
    private static final String DOWNLOAD_ACTION_FILE = "actions";
    private static final String DOWNLOAD_TRACKER_ACTION_FILE = "tracked_actions";
    private static final String DOWNLOAD_CONTENT_DIRECTORY = "downloads";
    private static final String SAMBA_PREF = "samba_pref";
    private String userAgent;
    private File downloadDirectory;
    private Cache downloadCache;
    private DownloadManager downloadManager;
    private SambaDownloadTracker sambaDownloadTracker;
    private Application applicationInstance;
    private boolean isConfigured;
    private static SambaDownloadManager instance;
    private PendingIntent pendingIntent;

    private SambaDownloadManager() {
    }

    public static SambaDownloadManager getInstance() {
        if (instance == null) {
            instance = new SambaDownloadManager();
        }
        return instance;
    }

    public void init(@NonNull Application application) {
        this.applicationInstance = application;
        if (application != null) {
            this.isConfigured = true;
        }
        this.userAgent = Util.getUserAgent((Context)this.applicationInstance.getApplicationContext(), (String)"SambaPlayer");
    }

    public void addDownloadListener(SambaDownloadListener listener) {
        this.checkConfig();
        this.getSambaDownloadTracker().addListener(listener);
    }

    public void removeDownloadListener(SambaDownloadListener listener) {
        this.checkConfig();
        this.getSambaDownloadTracker().removeListener(listener);
    }

    public void prepareDownload(@NonNull SambaDownloadRequest sambaDownloadRequest, @NonNull SambaDownloadRequestListener requestListener) {
        this.checkConfig();
        this.getSambaDownloadTracker().prepareDownload(sambaDownloadRequest, requestListener);
    }

    public void performDownload(@NonNull SambaDownloadRequest sambaDownloadRequest) {
        this.checkConfig();
        this.getSambaDownloadTracker().performDownload(sambaDownloadRequest);
    }

    public boolean isDownloaded(@NonNull String mediaId) {
        this.checkConfig();
        return this.getSambaDownloadTracker().isDownloaded(mediaId);
    }

    public boolean isDownloading(@NonNull String mediaId) {
        this.checkConfig();
        return this.getSambaDownloadTracker().isDownloading(mediaId);
    }

    public void cancelAllDownloads() {
        this.checkConfig();
        this.getSambaDownloadTracker().cancelAllDownloads();
    }

    public void cancelDownload(String mediaId) {
        this.checkConfig();
        this.getSambaDownloadTracker().cancelDownload(mediaId);
    }

    public void deleteDownload(String mediaId) {
        this.checkConfig();
        this.getSambaDownloadTracker().deleteDownload(mediaId);
    }

    public void deleteAllDownloads() {
        this.checkConfig();
        this.getSambaDownloadTracker().deleteAllDownloads();
    }

    public void startStoppedDownloads() {
        this.checkConfig();
        this.getSambaDownloadTracker().startStoppedDownloads();
    }

    public void stopAllDownloads() {
        this.checkConfig();
        this.getSambaDownloadTracker().stopAllDownloads();
    }

    public Application getAppInstance() {
        this.checkConfig();
        return this.applicationInstance;
    }

    public DataSource.Factory buildDataSourceFactory() {
        this.checkConfig();
        DefaultDataSourceFactory upstreamFactory = new DefaultDataSourceFactory(this.applicationInstance.getApplicationContext(), (DataSource.Factory)this.buildHttpDataSourceFactory());
        return SambaDownloadManager.buildReadOnlyCacheDataSource(upstreamFactory, this.getDownloadCache());
    }

    HttpDataSource.Factory buildHttpDataSourceFactory() {
        return new DefaultHttpDataSourceFactory(this.userAgent);
    }

    DownloadManager getDownloadManager() {
        this.initDownloadManager();
        return this.downloadManager;
    }

    SambaDownloadTracker getSambaDownloadTracker() {
        this.initDownloadManager();
        return this.sambaDownloadTracker;
    }

    private synchronized void initDownloadManager() {
        if (this.downloadManager == null) {
            DownloaderConstructorHelper downloaderConstructorHelper = new DownloaderConstructorHelper(this.getDownloadCache(), (DataSource.Factory)this.buildHttpDataSourceFactory());
            this.downloadManager = new DownloadManager(downloaderConstructorHelper, 1, 5, new File(this.getDownloadDirectory(), DOWNLOAD_ACTION_FILE), new DownloadAction.Deserializer[0]);
            this.sambaDownloadTracker = new SambaDownloadTracker(this.applicationInstance.getApplicationContext(), this.buildDataSourceFactory(), new File(this.getDownloadDirectory(), DOWNLOAD_TRACKER_ACTION_FILE), new DownloadAction.Deserializer[0]);
            this.downloadManager.addListener((DownloadManager.Listener)this.sambaDownloadTracker);
        }
    }

    private synchronized Cache getDownloadCache() {
        if (this.downloadCache == null) {
            File downloadContentDirectory = new File(this.getDownloadDirectory(), DOWNLOAD_CONTENT_DIRECTORY);
            this.downloadCache = new SimpleCache(downloadContentDirectory, (CacheEvictor)new NoOpCacheEvictor());
        }
        return this.downloadCache;
    }

    private File getDownloadDirectory() {
        if (this.downloadDirectory == null) {
            this.downloadDirectory = this.applicationInstance.getExternalFilesDir(null);
            if (this.downloadDirectory == null) {
                this.downloadDirectory = this.applicationInstance.getFilesDir();
            }
        }
        return this.downloadDirectory;
    }

    private static CacheDataSourceFactory buildReadOnlyCacheDataSource(DefaultDataSourceFactory upstreamFactory, Cache cache) {
        return new CacheDataSourceFactory(cache, (DataSource.Factory)upstreamFactory, 2, 0x1400000L);
    }

    public SharedPreferences getSharedPreferences() {
        this.checkConfig();
        return this.applicationInstance.getSharedPreferences(SAMBA_PREF, 0);
    }

    public String getUserAgent() {
        this.checkConfig();
        return this.userAgent;
    }

    public List<StreamKey> getOfflineStreamKeys(Uri uri) {
        this.checkConfig();
        return this.getSambaDownloadTracker().getOfflineStreamKeys(uri);
    }

    @Nullable
    public SambaMedia getDownloadedMedia(@NonNull String mediaId) {
        this.checkConfig();
        return this.getSambaDownloadTracker().getDownloadedMedia(mediaId);
    }

    @Nullable
    public List<SambaMedia> getDownloadedMedias() {
        this.checkConfig();
        return this.getSambaDownloadTracker().getDownloadedMedias();
    }

    public void updateDownloadedMedia(@NonNull SambaMedia sambaMedia) {
        this.checkConfig();
        this.getSambaDownloadTracker().updateDownloadedMedia(sambaMedia);
    }

    public void setPendingIntentForDownloadNotifications(@NonNull PendingIntent pendingIntent) {
        this.checkConfig();
        this.pendingIntent = pendingIntent;
    }

    PendingIntent getPendingIntentForDownloadNotifications() {
        return this.pendingIntent;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    private void checkConfig() {
        if (!this.isConfigured) {
            throw new RuntimeException("The SambaDownloadManager must be configured in the Application class. Call the \"SambaDownloadManager.getInstance().init(mApplication)\" in the \"onCreate()\" method of the Application class.");
        }
    }
}

