/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RadioButton;
import android.widget.TextView;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.TrackGroup;
import com.sambatech.player.R;

public class OutputSheetAdapter
extends BaseAdapter {
    public int currentIndex = -1;
    private int offset = 0;
    @NonNull
    private final Context context;
    @NonNull
    private final TrackGroup outputs;

    public OutputSheetAdapter(@NonNull Context context, @NonNull TrackGroup outputs, boolean abrEnabled) {
        this.context = context;
        this.outputs = outputs;
        this.offset = abrEnabled ? 1 : 0;
    }

    public int getCount() {
        return this.outputs.length + this.offset;
    }

    public Object getItem(int position) {
        if (this.offset == 1 && position == 0) {
            return null;
        }
        return this.outputs.getFormat(position - this.offset);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        OutputItem holder;
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        Format output = (Format)this.getItem(position);
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.action_sheet_item, parent, false);
            holder = new OutputItem(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (OutputItem)convertView.getTag();
        }
        if (output == null) {
            holder.label.setText(R.string.qualitty_auto);
        } else {
            holder.label.setText((CharSequence)(output.height > 0 ? output.height + "p" : Math.round((float)output.bitrate / 1000.0f) + "k"));
        }
        holder.radio.setChecked(this.currentIndex == position);
        return convertView;
    }

    private static class OutputItem {
        TextView label;
        RadioButton radio;

        OutputItem(View view) {
            this.radio = (RadioButton)view.findViewById(R.id.sheet_output_radio);
            this.label = (TextView)view.findViewById(R.id.sheet_item_label);
        }
    }
}

