/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.TextView;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.drm.UnsupportedDrmException;
import com.google.android.exoplayer2.source.BehindLiveWindowException;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.sambatech.player.PlayPauseState;
import com.sambatech.player.R;
import com.sambatech.player.SambaSimplePlayerView;
import com.sambatech.player.cast.CastDRM;
import com.sambatech.player.cast.CastObject;
import com.sambatech.player.cast.CastOptionsProvider;
import com.sambatech.player.cast.CastPlayer;
import com.sambatech.player.cast.CastQuery;
import com.sambatech.player.cast.SambaCast;
import com.sambatech.player.event.SambaCastListener;
import com.sambatech.player.event.SambaEvent;
import com.sambatech.player.event.SambaEventBus;
import com.sambatech.player.event.SambaPlayerListener;
import com.sambatech.player.mediasource.PlayerInstanceDefault;
import com.sambatech.player.mediasource.PlayerMediaSourceDash;
import com.sambatech.player.mediasource.PlayerMediaSourceExtractor;
import com.sambatech.player.mediasource.PlayerMediaSourceHLS;
import com.sambatech.player.mediasource.PlayerMediaSourceInterface;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.model.SambaMediaConfig;
import com.sambatech.player.model.SambaPlayerError;
import com.sambatech.player.plugins.PluginManager;
import com.sambatech.player.utils.CastLiveButtonListener;
import com.sambatech.player.utils.Helpers;
import com.sambatech.player.utils.Orientation;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SambaPlayer
extends FrameLayout {
    private final Player.DefaultEventListener playerEventListener = new Player.DefaultEventListener(){

        public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
            Format video = null;
            Format legenda = null;
            TrackSelection videos = null;
            if (trackSelections.length > 0) {
                videos = trackSelections.get(0);
            }
            if (videos != null && videos.getSelectionReason() != 1 && videos.getSelectionReason() != 4 && trackSelections.length > 0 && trackSelections.get(0) != null) {
                video = trackSelections.get(0).getSelectedFormat();
            }
            if (trackSelections.length > 2 && trackSelections.get(2) != null) {
                legenda = trackSelections.get(2).getSelectedFormat();
            }
            SambaPlayer.this.simplePlayerView.setupMenu(SambaPlayer.this.playerMediaSourceInterface, video, legenda, SambaPlayer.this._abrEnabled);
        }

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            Log.i((String)"SambaPlayer", (String)("state: " + playWhenReady + " " + playbackState + "; playing: " + SambaPlayer.this.isPlaying() + "; playingAd: " + SambaPlayer.this.player.isPlayingAd()));
            switch (playbackState) {
                case 3: {
                    if (playWhenReady) {
                        if (!SambaPlayer.this._hasStarted) {
                            SambaPlayer.this._hasStarted = true;
                            SambaPlayer.this._currentRetryIndex = 0;
                            SambaPlayer.this.destroyError();
                            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.START));
                            if (!((SambaPlayer)SambaPlayer.this).media.isLive && SambaPlayer.this._initialTime > 0.0f) {
                                SambaPlayer.this.seek(SambaPlayer.this._initialTime);
                                SambaPlayer.this._initialTime = 0.0f;
                            }
                            if (SambaPlayer.this._initialFullscreen != null) {
                                SambaPlayer.this.simplePlayerView.setFullscreen(SambaPlayer.this._initialFullscreen);
                                SambaPlayer.this._initialFullscreen = null;
                            }
                        }
                        SambaPlayer.this.dispatchPlay();
                    } else {
                        SambaPlayer.this.dispatchPause();
                    }
                    SambaPlayer.this.simplePlayerView.updatePlayPause(playWhenReady ? PlayPauseState.Playing : PlayPauseState.Pause);
                    this.adjustCurrentOutputs();
                    break;
                }
                case 4: {
                    if (!playWhenReady || SambaPlayer.this.player.isPlayingAd()) break;
                    SambaPlayer.this.pause();
                    SambaPlayer.this.player.seekTo(0L);
                    Log.d((String)"ContentValues", (String)("onPlayerStateChanged: " + SambaPlayer.this.player.isPlayingAd()));
                    SambaPlayer.this.stopProgressTimer();
                    SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FINISH));
                    SambaPlayer.this._hasFinished = true;
                    SambaPlayer.this.simplePlayerView.updatePlayPause(PlayPauseState.Pause);
                    break;
                }
                case 2: {
                    SambaPlayer.this.simplePlayerView.updatePlayPause(PlayPauseState.Loading);
                    SambaPlayer.this.stopErrorTimer();
                    final AtomicInteger secs = new AtomicInteger(20);
                    SambaPlayer.this.errorTimer = new Timer();
                    SambaPlayer.this.errorTimer.scheduleAtFixedRate(new TimerTask(){

                        @Override
                        public void run() {
                            ((Activity)SambaPlayer.this.getContext()).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (secs.get() == 0) {
                                        SambaPlayer.this.stopErrorTimer();
                                    }
                                    secs.decrementAndGet();
                                }
                            });
                        }
                    }, 0L, 1000L);
                }
            }
        }

        public void onPlayerError(ExoPlaybackException e) {
            final Exception error = (Exception)e.getCause();
            Log.d((String)"SambaPlayer", (String)("Error: " + SambaPlayer.this.media), (Throwable)error);
            String msg = "Voc\u00ea est\u00e1 offline! Verifique sua conex\u00e3o.";
            SambaPlayerError.Severity severity = SambaPlayerError.Severity.recoverable;
            boolean isBehindLiveWindowException = error instanceof BehindLiveWindowException;
            if (SambaPlayer.this._initialTime == 0.0f) {
                SambaPlayer.this._initialTime = SambaPlayer.this.getCurrentTime();
            }
            SambaPlayer.this._currentOutputIndex = SambaPlayer.this.playerMediaSourceInterface.getCurrentOutputTrackIndex(SambaPlayer.this.player.getCurrentTrackSelections(), SambaPlayer.this._abrEnabled);
            SambaPlayer.this._currentCaptionIndex = SambaPlayer.this.playerMediaSourceInterface.getCurrentCaptionTrackIndex(SambaPlayer.this.player.getCurrentTrackSelections());
            if (SambaPlayer.this._currentCaptionIndex >= 0) {
                SambaPlayer.this._forceCaptionIndexTo = SambaPlayer.this._currentCaptionIndex;
            }
            if (SambaPlayer.this._currentOutputIndex >= 0) {
                SambaPlayer.this._forceOutputIndexTo = SambaPlayer.this._currentOutputIndex;
            }
            SambaPlayer.this._initialFullscreen = SambaPlayer.this.simplePlayerView.isFullscreen();
            SambaPlayer.this.destroyInternal();
            if (error.getCause() instanceof UnsupportedDrmException) {
                msg = String.format("Voc\u00ea n\u00e3o tem permiss\u00e3o para %s", ((SambaPlayer)SambaPlayer.this).media.isAudioOnly ? "ouvir este \u00e1udio." : "assistir este v\u00eddeo.");
                severity = SambaPlayerError.Severity.critical;
            } else if (isBehindLiveWindowException) {
                msg = "Instabilidade na rede ou no envio de dados.";
                severity = SambaPlayerError.Severity.minor;
                SambaPlayer.this.create(false);
            } else if (Helpers.isNetworkAvailable(SambaPlayer.this.getContext())) {
                msg = "Conectando...";
                severity = SambaPlayerError.Severity.info;
                try {
                    HttpURLConnection con = (HttpURLConnection)new URL(String.format("%s://www.google.com", new Object[]{((SambaPlayer)SambaPlayer.this).media.request.protocol})).openConnection();
                    con.setConnectTimeout(1000);
                    con.setReadTimeout(1000);
                    Helpers.requestUrl(con, new Helpers.RequestCallback(){

                        @Override
                        public void onSuccess(String response) {
                            ((Activity)SambaPlayer.this.getContext()).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    if (SambaPlayer.this._currentBackupIndex < ((SambaPlayer)SambaPlayer.this).media.backupUrls.length) {
                                        ((SambaPlayer)SambaPlayer.this).media.url = ((SambaPlayer)SambaPlayer.this).media.backupUrls[SambaPlayer.this._currentBackupIndex++];
                                        SambaPlayer.this.create(false);
                                        SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), "Conectando...", SambaPlayerError.Severity.info, error));
                                        return;
                                    }
                                    SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), "Ocorreu um erro! Por favor, tente mais tarde...", SambaPlayerError.Severity.critical, error));
                                }
                            });
                        }

                        @Override
                        public void onError(Exception e, String response) {
                            SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), "Voc\u00ea est\u00e1 offline! Verifique sua conex\u00e3o.", SambaPlayerError.Severity.recoverable, e));
                        }
                    });
                }
                catch (IOException e1) {
                    msg = "Ocorreu um erro! Por favor, tente novamente.";
                    severity = SambaPlayerError.Severity.recoverable;
                }
            } else if (SambaPlayer.this._currentRetryIndex++ < ((SambaPlayer)SambaPlayer.this).media.retriesTotal) {
                final AtomicInteger secs = new AtomicInteger(8);
                SambaPlayer.this.stopErrorTimer();
                SambaPlayer.this.errorTimer = new Timer();
                SambaPlayer.this.errorTimer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        ((Activity)SambaPlayer.this.getContext()).runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (secs.get() == 0) {
                                    SambaPlayer.this.stopErrorTimer();
                                    SambaPlayer.this.create(false);
                                }
                                SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), secs.get() > 0 ? String.format("Reconectando em %ss", secs) : "Conectando...", SambaPlayerError.Severity.info, error, R.drawable.sambaplayer_ic_nosignal));
                                secs.decrementAndGet();
                            }
                        });
                    }
                }, 0L, 1000L);
                return;
            }
            SambaPlayer.this.dispatchError(SambaPlayerError.unknown.setValues(SambaPlayerError.unknown.getCode(), msg, severity, error));
        }

        public void onPositionDiscontinuity(int reason) {
            this.adjustCurrentOutputs();
        }

        private void adjustCurrentOutputs() {
            if (!SambaPlayer.this.player.isPlayingAd() && SambaPlayer.this.playerMediaSourceInterface != null) {
                if (SambaPlayer.this._forceOutputIndexTo >= 0) {
                    SambaPlayer.this.playerMediaSourceInterface.forceOutuputTrackTo(SambaPlayer.this._forceOutputIndexTo, SambaPlayer.this._abrEnabled);
                    SambaPlayer.this._forceOutputIndexTo = -1;
                }
                if (SambaPlayer.this._forceCaptionIndexTo >= 0) {
                    SambaPlayer.this.playerMediaSourceInterface.forceCaptionTrackTo(SambaPlayer.this._forceCaptionIndexTo);
                    SambaPlayer.this._forceCaptionIndexTo = -1;
                }
            }
        }
    };
    private final SambaSimplePlayerView.FullscreenCallback fullscreenListener = new SambaSimplePlayerView.FullscreenCallback(){

        @Override
        public void onGoToFullscreen() {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN));
        }

        @Override
        public void onReturnFromFullscreen() {
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.FULLSCREEN_EXIT));
        }
    };
    private final Runnable progressDispatcher = new Runnable(){

        @Override
        public void run() {
            if (SambaPlayer.this.player == null) {
                return;
            }
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PROGRESS, Float.valueOf(SambaPlayer.this.getCurrentTime()), Float.valueOf(SambaPlayer.this.getDuration())));
        }
    };
    private final SambaCastListener castListener = new SambaCastListener(){
        RemoteMediaClient remoteMediaClient;

        @Override
        public void onConnected(CastSession castSession) {
            SambaPlayer.this.stopProgressTimer();
            SambaPlayer.this.player.setPlayWhenReady(false);
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.CAST_CONNECT));
            RemoteMediaClient remoteMediaClient = castSession.getRemoteMediaClient();
            if (remoteMediaClient == null) {
                return;
            }
            SambaPlayer.this.castPlayer.setRemoteMediaClient(remoteMediaClient);
            SambaPlayer.this.castPlayer.setIsLive(((SambaPlayer)SambaPlayer.this).media.isLive);
            MediaMetadata movieMetadata = new MediaMetadata(1);
            movieMetadata.putString("com.google.android.gms.cast.metadata.TITLE", ((SambaPlayer)SambaPlayer.this).media.title);
            movieMetadata.putString("com.google.android.gms.cast.metadata.SUBTITLE", ((SambaPlayer)SambaPlayer.this).media.title);
            CastQuery qs = new CastQuery(true, CastOptionsProvider.environment.toString(), CastOptionsProvider.appId, (long)SambaPlayer.this.getCurrentTime(), SambaPlayer.this.getCaption());
            CastObject castObject = new CastObject(((SambaPlayer)SambaPlayer.this).media.title, ((SambaPlayer)SambaPlayer.this).media.id, (long)((SambaPlayer)SambaPlayer.this).media.duration, ((SambaPlayer)SambaPlayer.this).media.themeColorHex, ((SambaPlayer)SambaPlayer.this).media.projectHash, qs, "", CastOptionsProvider.playerUrl);
            if (((SambaPlayer)SambaPlayer.this).media.isLive) {
                castObject.setLive(((SambaPlayer)SambaPlayer.this).media.id);
            } else {
                castObject.setLive(null);
            }
            if (((SambaPlayer)SambaPlayer.this).media.drmRequest != null) {
                castObject.setDrm(new CastDRM(((SambaPlayer)SambaPlayer.this).media.drmRequest.getLicenseParam("SessionId"), ((SambaPlayer)SambaPlayer.this).media.drmRequest.getLicenseParam("Ticket")));
            }
            MediaInfo mediaInfo = new MediaInfo.Builder(castObject.toString()).setStreamType(1).setContentType("video/mp4").setMetadata(movieMetadata).build();
            MediaQueueItem[] mediaQueueItems = new MediaQueueItem[]{new MediaQueueItem.Builder(mediaInfo).build()};
            String tempMediaCasting = SambaCast.currentMediaCastingId(SambaPlayer.this.getContext());
            if (tempMediaCasting == null || !tempMediaCasting.equals(((SambaPlayer)SambaPlayer.this).media.id)) {
                PendingResult<RemoteMediaClient.MediaChannelResult> result = SambaPlayer.this.castPlayer.loadItems(mediaQueueItems, 0, 0L, 0);
                result.setResultCallback((ResultCallback)new ResultCallback<RemoteMediaClient.MediaChannelResult>(){

                    public void onResult(@NonNull RemoteMediaClient.MediaChannelResult mediaChannelResult) {
                        SambaCast.setCurrentMediaCastingId(SambaPlayer.this.getContext(), ((SambaPlayer)SambaPlayer.this).media.id);
                        SambaPlayer.this.castPlayer.setPlayWhenReady(true);
                    }
                }, 5L, TimeUnit.SECONDS);
            } else {
                SambaPlayer.this.castPlayer.resumeItems(mediaQueueItems, 0, 0);
                SambaPlayer.this.castPlayer.syncInternalState();
            }
            SambaPlayer.this.sambaCast.registerDeviceForProgress(true);
            SambaPlayer.this.castPlayer.setMessageListener(castSession);
            SambaPlayer.this.simplePlayerView.showCast(((SambaPlayer)SambaPlayer.this).media.isLive, new CastLiveButtonListener(){

                @Override
                public void onLiveButtonClicked(View view) {
                    SambaCast.cleanCacheDatas(SambaPlayer.this.getContext());
                    SambaPlayer.this.castPlayer.setPlayWhenReady(false);
                    SambaPlayer.this.castPlayer.updateInternalState();
                    SambaPlayer.this.castListener.onConnected();
                }
            });
            this.remoteMediaClient = remoteMediaClient;
        }

        @Override
        public void onConnected() {
            this.onConnected(SambaPlayer.this.sambaCast.getCastSession());
        }

        @Override
        public void onDisconnected() {
            SambaCast.cleanCacheDatas(SambaPlayer.this.getContext());
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.CAST_DISCONNECT));
            long lastPosition = SambaPlayer.this.castPlayer.getContentPosition();
            if (SambaPlayer.this.simplePlayerView != null) {
                SambaPlayer.this.simplePlayerView.setupCastButton(false);
            }
            if (SambaPlayer.this.player != null) {
                SambaPlayer.this.player.seekTo(lastPosition);
            }
            SambaPlayer.this.play();
            SambaPlayer.this.startProgressTimer();
            if (SambaPlayer.this.simplePlayerView != null) {
                SambaPlayer.this.simplePlayerView.hideCast();
            }
        }
    };
    private View errorScreen;
    @NonNull
    private SambaMediaConfig media = new SambaMediaConfig();
    private Timer progressTimer;
    private boolean _hasStarted;
    private boolean _hasFinished;
    private OrientationEventListener orientationEventListener;
    private SambaCast sambaCast;
    private boolean _autoFsMode;
    private boolean _enableControls = true;
    private boolean _disabled;
    private float _initialTime = 0.0f;
    private Boolean _initialFullscreen = null;
    private Timer errorTimer;
    private List<String> controlsHidden = new ArrayList<String>();
    private boolean _abrEnabled = true;
    private int _forceOutputIndexTo = -1;
    private int _forceCaptionIndexTo = -1;
    private int _currentBackupIndex;
    private int _currentRetryIndex;
    private int _currentOutputIndex = -1;
    private int _currentCaptionIndex = -1;
    private SambaSimplePlayerView simplePlayerView;
    private SimpleExoPlayer player;
    private PlayerInstanceDefault playerInstanceDefault;
    private PlayerMediaSourceInterface playerMediaSourceInterface;
    CastPlayer castPlayer;

    public SambaPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SambaPlayer, 0, 0));
    }

    public void setMedia(@NonNull SambaMedia media) {
        SambaMediaConfig m;
        this.media = m = new SambaMediaConfig(media);
        this._initialTime = m.initialTime;
        if (m.blockIfRooted && Helpers.isDeviceRooted()) {
            this._disabled = true;
            this.dispatchError(SambaPlayerError.rootedDevice);
            return;
        }
        this.destroy();
        PluginManager.getInstance().onLoad(this);
    }

    @NonNull
    public SambaMedia getMedia() {
        return this.media;
    }

    public void play(boolean abrEnabled, int outputIndex) {
        this._abrEnabled = abrEnabled;
        this._forceOutputIndexTo = outputIndex == -1 && !abrEnabled ? 0 : outputIndex;
        this._forceCaptionIndexTo = 0;
        if (this._disabled || this.errorScreen != null) {
            return;
        }
        if (!PluginManager.getInstance().isLoaded()) {
            PluginManager.getInstance().setPendingPlay(true);
            return;
        }
        if (this.player == null) {
            this.create();
            return;
        }
        if (this._forceOutputIndexTo >= 0) {
            this.playerMediaSourceInterface.forceOutuputTrackTo(this._forceOutputIndexTo, this._abrEnabled);
        }
        this._forceOutputIndexTo = -1;
        if (this.sambaCast != null && this.sambaCast.isCasting() && this.castPlayer != null) {
            this.castPlayer.setPlayWhenReady(true);
            this.stopProgressTimer();
            this.player.setPlayWhenReady(false);
        } else {
            this.player.setPlayWhenReady(true);
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PLAY));
        }
    }

    public void play() {
        this.play(true, -1);
    }

    public void pause() {
        if (this.player == null) {
            return;
        }
        if (this.sambaCast != null && this.sambaCast.isCasting() && this.castPlayer != null) {
            this.castPlayer.setPlayWhenReady(false);
        } else {
            this.player.setPlayWhenReady(false);
            SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PAUSE));
        }
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        if (this.sambaCast == null || !this.sambaCast.isCasting()) {
            this.player.stop();
        }
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.STOP));
    }

    public void seek(float position) {
        if (this.player == null) {
            return;
        }
        if (this.sambaCast != null && this.sambaCast.isCasting()) {
            this.sambaCast.seekTo((int)(position * 1000.0f));
        } else {
            this.player.seekTo((long)Math.round(position * 1000.0f));
        }
    }

    public void setControlsVisibility(boolean flag) {
        this._enableControls = flag;
        if (this.player == null && this.simplePlayerView == null) {
            return;
        }
        this.simplePlayerView.setEnableControls(flag);
    }

    public void setHideControls(String ... controls) {
        if (controls.length == 0) {
            return;
        }
        this.controlsHidden = Arrays.asList(controls);
        if (this.player == null) {
            return;
        }
        this.simplePlayerView.setControlsVisible(false, controls);
    }

    public void setFullscreen(boolean flag) {
        if (this.player == null || this.simplePlayerView == null) {
            return;
        }
        this.simplePlayerView.setFullscreen(flag);
    }

    public boolean isFullscreen() {
        return this.simplePlayerView != null && this.simplePlayerView.isFullscreen();
    }

    public void setAutoFullscreenMode(boolean flag) {
        this._autoFsMode = flag;
    }

    public float getCurrentTime() {
        if (this.sambaCast != null && this.sambaCast.isCasting() && this.castPlayer != null) {
            return (float)this.castPlayer.getCurrentPosition() / 1000.0f;
        }
        return this.player != null ? (float)this.player.getCurrentPosition() / 1000.0f : 0.0f;
    }

    public float getDuration() {
        if (this.sambaCast != null && this.sambaCast.isCasting() && this.castPlayer != null) {
            return (float)this.castPlayer.getDuration() / 1000.0f;
        }
        return this.player != null ? (float)this.player.getDuration() / 1000.0f : this.media.duration;
    }

    public boolean isPlaying() {
        return this.player != null && this.player.getPlayWhenReady() && (this.player.getPlaybackState() == 3 || this.player.getPlaybackState() == 2);
    }

    public boolean hasStarted() {
        return this._hasStarted;
    }

    public boolean hasFinished() {
        return this._hasFinished;
    }

    public void switchOutput(int index) {
        if (this.player == null || this.simplePlayerView == null || this.playerMediaSourceInterface == null) {
            return;
        }
        this.playerMediaSourceInterface.forceOutuputTrackTo(index, this._abrEnabled);
    }

    public int getCurrentOutputIndex() {
        if (this.player == null || this.player.getCurrentTrackSelections() == null || this.simplePlayerView == null || this.playerMediaSourceInterface == null) {
            return -1;
        }
        return this.playerMediaSourceInterface.getCurrentOutputTrackIndex(this.player.getCurrentTrackSelections(), this._abrEnabled);
    }

    public void changeCaption(int index) {
        if (this.player == null || this.simplePlayerView == null || this.playerMediaSourceInterface == null) {
            return;
        }
        this.playerMediaSourceInterface.forceCaptionTrackTo(index);
    }

    public String getCaption() {
        if (this.player == null || this.simplePlayerView == null || this.playerMediaSourceInterface == null) {
            return "";
        }
        Format caption = null;
        if (this.player.getCurrentTrackSelections().length > 2 && this.player.getCurrentTrackSelections().get(2) != null) {
            caption = this.player.getCurrentTrackSelections().get(2).getSelectedFormat();
        }
        return String.format("[%s,ffcc00,42]", caption != null && caption.language != null ? caption.language : "");
    }

    public int getCurrentCaptionIndex() {
        if (this.player == null || this.player.getCurrentTrackSelections() == null || this.simplePlayerView == null || this.playerMediaSourceInterface == null) {
            return -1;
        }
        return this.playerMediaSourceInterface.getCurrentCaptionTrackIndex(this.player.getCurrentTrackSelections());
    }

    public void setSambaCast(@NonNull SambaCast sambaCast) {
        this.sambaCast = sambaCast;
        this.setupCast();
    }

    public void destroy() {
        this.destroy(null);
    }

    public void destroy(SambaPlayerError error) {
        PluginManager.getInstance().onDestroy();
        this.destroyInternal();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.DESTROY));
        if (error != null) {
            this.showError(error);
        } else {
            this.destroyError();
        }
    }

    private void applyAttributes(TypedArray attrs) {
        try {
            this.setAutoFullscreenMode(attrs.getBoolean(R.styleable.SambaPlayer_autoFullscreenMode, false));
            this.setControlsVisibility(attrs.getBoolean(R.styleable.SambaPlayer_enableControls, true));
        }
        finally {
            attrs.recycle();
        }
    }

    private void create() {
        this.create(true, true);
    }

    private void create(boolean notify) {
        this.create(notify, true);
    }

    private void create(boolean notify, boolean isAutoPlay) {
        if (this.player != null) {
            Log.i((String)"SambaPlayer", (String)"Player already created!");
            return;
        }
        if (this.media.url == null || this.media.url.isEmpty()) {
            this.dispatchError(SambaPlayerError.emptyUrl);
            return;
        }
        this.playerInstanceDefault = new PlayerInstanceDefault(this.getContext());
        this.simplePlayerView = new SambaSimplePlayerView(this.getContext(), this);
        this.player = this.playerInstanceDefault.createPlayerInstance();
        this.simplePlayerView.setPlayer(this.player);
        this.simplePlayerView.setVideoTitle(this.media.title);
        this.simplePlayerView.configureSubTitle(this.media.captionsConfig);
        this.simplePlayerView.configView(!this.media.isAudioOnly, this.media.isLive, this.media.isDvr, this.sambaCast != null && !this.sambaCast.isCastButtonOut());
        this.simplePlayerView.setEnableControls(this._enableControls);
        if (this.media.url.toLowerCase().endsWith(".mp3")) {
            this.media.type = "progressive";
        }
        switch (this.media.type.toLowerCase()) {
            case "hls": {
                this.playerMediaSourceInterface = new PlayerMediaSourceHLS(this.playerInstanceDefault, this.media.url);
                break;
            }
            case "dash": {
                this.playerMediaSourceInterface = new PlayerMediaSourceDash(this.playerInstanceDefault, this.media.url);
                break;
            }
            default: {
                this.playerMediaSourceInterface = new PlayerMediaSourceExtractor(this.playerInstanceDefault, this.media.url);
            }
        }
        this.player.addListener((Player.EventListener)this.playerEventListener);
        this.player.setPlayWhenReady(true);
        if (this.media.captions != null && this.media.captions.size() > 0) {
            this.playerMediaSourceInterface.addSubtitles(this.media.captions);
        }
        if (this.media.adUrl != null) {
            this.playerMediaSourceInterface.addAds(this.media.adUrl, this.simplePlayerView.getPlayerView().getOverlayFrameLayout());
        }
        this.player.prepare(this.playerMediaSourceInterface.getMediaSource());
        this.player.setRepeatMode(0);
        this.simplePlayerView.setThemeColor(this.media.themeColor);
        if (this.media.isAudioOnly) {
            if (this.media.thumbAudioURL != null && !this.media.thumbAudioURL.isEmpty()) {
                this.simplePlayerView.setBackgroundImageThumb(this.media.thumbAudioURL);
            } else {
                this.simplePlayerView.setBackgroundColor(-12369085);
            }
            this.simplePlayerView.setChromeColor(0);
        } else {
            this.simplePlayerView.setFullscreenCallback(this.fullscreenListener);
        }
        if (!this.controlsHidden.isEmpty()) {
            this.setHideControls(this.controlsHidden.toArray(new String[0]));
        }
        this.createOrientationEventListener();
        if (!this.media.isAudioOnly) {
            PluginManager.getInstance().onInternalPlayerCreated(this.simplePlayerView.getPlayerView());
            if (notify) {
                SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LOAD, new Object[]{this}));
            }
        }
        if (this.media.isAudioOnly) {
            if (this.sambaCast != null && this.sambaCast.isCasting()) {
                this.sambaCast.setEventListener(null);
                this.sambaCast.stopCasting();
            } else {
                SambaCast.cleanCacheDatas(this.getContext());
            }
        } else {
            this.setupCast();
            this.simplePlayerView.createCastPlayer(this.castPlayer, this.media.themeColor, this.media.captions);
            if (this.sambaCast != null && this.sambaCast.isCasting()) {
                this.castListener.onConnected(this.sambaCast.getCastSession());
            } else {
                SambaCast.cleanCacheDatas(this.getContext());
            }
        }
    }

    private void createOrientationEventListener() {
        this.orientationEventListener = new OrientationEventListener(this.getContext()){
            private final Orientation orientation;
            private int lastRotatedTo;
            {
                this.orientation = new Orientation();
                this.lastRotatedTo = 0;
                this.enable();
            }

            public void onOrientationChanged(int newValue) {
                if (!SambaPlayer.this._autoFsMode || SambaPlayer.this.player == null || SambaPlayer.this.simplePlayerView == null) {
                    return;
                }
                int newOrientation = this.orientation.getMeasuredOrientation(newValue);
                if (newOrientation == this.lastRotatedTo || newOrientation == -1) {
                    return;
                }
                this.lastRotatedTo = newOrientation;
                switch (this.lastRotatedTo) {
                    case 0: {
                        SambaPlayer.this.simplePlayerView.setFullscreen(false);
                        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PORTRAIT));
                        break;
                    }
                    case 90: {
                        SambaPlayer.this.simplePlayerView.setFullscreen(true, true);
                        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LANDSCAPE));
                        break;
                    }
                    case 270: {
                        SambaPlayer.this.simplePlayerView.setFullscreen(true, false);
                        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.LANDSCAPE));
                        break;
                    }
                }
            }
        };
    }

    private void destroyInternal() {
        this.stopProgressTimer();
        this.stopErrorTimer();
        this.stop();
        this.setFullscreen(false);
        if (this.orientationEventListener != null) {
            this.orientationEventListener.disable();
            this.orientationEventListener = null;
        }
        if (this.sambaCast != null) {
            this.sambaCast.setEventListener(null);
        }
        if (this.simplePlayerView != null) {
            this.simplePlayerView.setFullscreenCallback(null);
            this.simplePlayerView.destroyInternal();
            this.simplePlayerView = null;
        }
        if (this.playerInstanceDefault != null) {
            this.playerInstanceDefault.destroy();
            this.playerInstanceDefault = null;
        }
        if (this.playerMediaSourceInterface != null) {
            this.playerMediaSourceInterface.destroy();
            this.playerMediaSourceInterface = null;
        }
        if (this.player != null) {
            this.player.removeListener((Player.EventListener)this.playerEventListener);
            this.player.release();
            this.player = null;
        }
        this._hasStarted = false;
        this._hasFinished = false;
        this._disabled = false;
    }

    private void showError(@NonNull SambaPlayerError error) {
        if (this.errorScreen == null) {
            this.errorScreen = ((Activity)this.getContext()).getLayoutInflater().inflate(R.layout.error_screen, (ViewGroup)this, false);
        }
        TextView textView = (TextView)this.errorScreen.findViewById(R.id.error_message);
        textView.setText((CharSequence)error.toString());
        ImageButton retryButton = (ImageButton)this.errorScreen.findViewById(R.id.retry_button);
        retryButton.setVisibility(error.getSeverity() == SambaPlayerError.Severity.recoverable ? 0 : 8);
        retryButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SambaPlayer.this.destroyInternal();
                SambaPlayer.this.create(false);
            }
        });
        if (this.media.isAudioOnly) {
            if (error.getSeverity() == SambaPlayerError.Severity.recoverable) {
                textView.setVisibility(8);
            } else {
                textView.setCompoundDrawables(null, null, null, null);
            }
        } else if (error.getDrawableRes() > 0) {
            textView.setCompoundDrawablesWithIntrinsicBounds(0, error.getDrawableRes(), 0, 0);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(0, R.drawable.sambaplayer_error_icon, 0, 0);
        }
        if (this.errorScreen.getParent() == null) {
            this.addView(this.errorScreen);
        }
    }

    private void destroyError() {
        this.stopErrorTimer();
        if (this.errorScreen == null) {
            return;
        }
        this.errorScreen.findViewById(R.id.retry_button).setOnClickListener(null);
        this.removeView(this.errorScreen);
        this.errorScreen = null;
    }

    private void startProgressTimer() {
        if (this.progressTimer != null) {
            return;
        }
        this.progressTimer = new Timer();
        this.progressTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)SambaPlayer.this.getContext()).runOnUiThread(SambaPlayer.this.progressDispatcher);
            }
        }, 0L, 250L);
    }

    private void stopProgressTimer() {
        if (this.progressTimer == null) {
            return;
        }
        this.progressTimer.cancel();
        this.progressTimer.purge();
        this.progressTimer = null;
    }

    private void stopErrorTimer() {
        if (this.errorTimer == null) {
            return;
        }
        this.errorTimer.cancel();
        this.errorTimer.purge();
        this.errorTimer = null;
    }

    private void dispatchPlay() {
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PLAY));
        this.startProgressTimer();
    }

    private void dispatchPause() {
        this.stopProgressTimer();
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.PAUSE));
        Log.i((String)"Teste", (String)("" + this.sambaCast.isCasting()));
    }

    private void dispatchError(@NonNull SambaPlayerError error) {
        SambaEventBus.post(new SambaEvent(SambaPlayerListener.EventType.ERROR, new Object[]{error}));
        switch (error.getSeverity()) {
            case critical: {
                this.destroy(error);
                break;
            }
            case info: 
            case recoverable: {
                this.showError(error);
            }
        }
    }

    private void setupCast() {
        if (this.sambaCast == null || this.media.isAudioOnly) {
            return;
        }
        this.sambaCast.setEventListener(this.castListener);
        this.castPlayer = new CastPlayer(this.getContext(), this.sambaCast);
    }
}

