/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.mediasource;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ext.ima.ImaAdsLoader;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MergingMediaSource;
import com.google.android.exoplayer2.source.SingleSampleMediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.ads.AdsLoader;
import com.google.android.exoplayer2.source.ads.AdsMediaSource;
import com.google.android.exoplayer2.trackselection.FixedTrackSelection;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.sambatech.player.mediasource.PlayerInstanceDefault;
import com.sambatech.player.model.SambaMedia;
import java.util.ArrayList;

public class PlayerMediaSource {
    protected static final int VIDEO_TRACK_GROUP_INDEX = 0;
    protected static final int VIDEO_RENDERER_INDEX = 0;
    protected static final int CAPTION_RENDERER_INDEX = 2;
    protected static final int CAPTION_FORMAT_INDEX = 0;
    protected PlayerInstanceDefault playerInstanceDefault;
    protected String url;
    protected MediaSource mediaSource;
    protected AdsLoader adsLoader;

    protected PlayerMediaSource(@NonNull PlayerInstanceDefault playerInstanceDefault) {
        this.playerInstanceDefault = playerInstanceDefault;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    protected void setMediaSource(MediaSource mediaSource) {
        this.mediaSource = mediaSource;
    }

    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    private MappingTrackSelector.MappedTrackInfo getMappedTrackInfo() {
        if (this.playerInstanceDefault.trackSelector == null) {
            return null;
        }
        return this.playerInstanceDefault.trackSelector.getCurrentMappedTrackInfo();
    }

    private TrackGroupArray getTrackGroupArray(int renderIndex) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.getMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return null;
        }
        return mappedTrackInfo.getTrackGroups(renderIndex);
    }

    public TrackGroup getVideoOutputsTracks() {
        TrackGroupArray trackGroupArray = this.getTrackGroupArray(0);
        if (trackGroupArray == null || 0 >= trackGroupArray.length) {
            return null;
        }
        return trackGroupArray.get(0);
    }

    public void setVideoOutputTrack(Format format) {
        if (format == null) {
            this.playerInstanceDefault.trackSelector.clearSelectionOverride(0, this.getTrackGroupArray(0));
            return;
        }
        int index = this.getVideoOutputsTracks().indexOf(format);
        MappingTrackSelector.SelectionOverride override = new MappingTrackSelector.SelectionOverride((TrackSelection.Factory)new FixedTrackSelection.Factory(), 0, new int[]{index});
        this.playerInstanceDefault.trackSelector.setSelectionOverride(0, this.getTrackGroupArray(0), override);
    }

    public void addSubtitles(ArrayList<SambaMedia.Caption> captions) {
        if (captions == null || this.mediaSource == null) {
            return;
        }
        int captionID = 0;
        for (SambaMedia.Caption caption : captions) {
            if (caption.url == null || caption.label == null) continue;
            Format subs = Format.createTextSampleFormat((String)String.valueOf(captionID), (String)"application/x-subrip", (int)4, (String)caption.label);
            SingleSampleMediaSource subSource = new SingleSampleMediaSource.Factory((DataSource.Factory)new DefaultHttpDataSourceFactory("userAgent")).createMediaSource(Uri.parse((String)caption.url), subs, -9223372036854775807L);
            this.mediaSource = new MergingMediaSource(new MediaSource[]{this.mediaSource, subSource});
            ++captionID;
        }
    }

    public TrackGroupArray getSubtitles() {
        return this.getTrackGroupArray(2);
    }

    public void setSubtitle(TrackGroup trackGroup) {
        if (trackGroup == null) {
            this.playerInstanceDefault.trackSelector.clearSelectionOverride(2, this.getTrackGroupArray(2));
            return;
        }
        int index = this.getTrackGroupArray(2).indexOf(trackGroup);
        MappingTrackSelector.SelectionOverride override = new MappingTrackSelector.SelectionOverride((TrackSelection.Factory)new FixedTrackSelection.Factory(), index, new int[]{0});
        this.playerInstanceDefault.trackSelector.setSelectionOverride(2, this.getTrackGroupArray(2), override);
    }

    public void addAds(String url, FrameLayout frameLayout) {
        this.adsLoader = new ImaAdsLoader(this.playerInstanceDefault.context, Uri.parse((String)url));
        this.mediaSource = new AdsMediaSource(this.mediaSource, this.playerInstanceDefault.mediaDataSourceFactory, this.adsLoader, (ViewGroup)frameLayout);
    }

    public void forceOutuputTrackTo(int index, boolean isAbrEnabled) {
        this.setVideoOutputTrack(this.getOutputByIndex(index, isAbrEnabled));
    }

    public int getCurrentOutputTrackIndex(TrackSelectionArray trackSelections, boolean isAbrEnabled) {
        Format video = null;
        TrackSelection videos = null;
        TrackGroup trackGroup = this.getVideoOutputsTracks();
        int index = -1;
        if (trackSelections.length > 0) {
            videos = trackSelections.get(0);
        }
        if (videos == null || trackGroup == null || trackSelections == null) {
            return index;
        }
        if (videos.getSelectionReason() != 1 && videos.getSelectionReason() != 4) {
            if (trackSelections.length > 0 && trackSelections.get(0) != null) {
                video = trackSelections.get(0).getSelectedFormat();
            }
            if (video != null) {
                index = trackGroup.indexOf(video);
            }
            if (index != -1) {
                index = isAbrEnabled ? index + 1 : index;
            }
        } else if (isAbrEnabled) {
            return 0;
        }
        return index;
    }

    public void forceCaptionTrackTo(int index) {
        TrackGroup forcedCaption = this.getCaptionByIndex(index);
        if (forcedCaption != null) {
            this.setSubtitle(forcedCaption);
        }
    }

    public Format getOutputByIndex(int index, boolean isAbrEnabled) {
        Format output = null;
        TrackGroup trackGroup = this.getVideoOutputsTracks();
        if (!(trackGroup == null || isAbrEnabled && index == 0)) {
            if (trackGroup.length > (index -= isAbrEnabled ? 1 : 0)) {
                output = this.getVideoOutputsTracks().getFormat(index);
            } else if (!isAbrEnabled) {
                output = this.getVideoOutputsTracks().getFormat(0);
            }
        }
        return output;
    }

    public int getCurrentCaptionTrackIndex(TrackSelectionArray trackSelections) {
        TrackGroup legenda = null;
        int index = -1;
        TrackGroupArray trackGroupArray = this.getTrackGroupArray(2);
        if (trackGroupArray != null && trackSelections != null) {
            if (trackSelections.length > 2 && trackSelections.get(2) != null) {
                legenda = trackSelections.get(2).getTrackGroup();
            }
            index = trackGroupArray.indexOf(legenda);
        }
        return index;
    }

    public TrackGroup getCaptionByIndex(int index) {
        TrackGroupArray captions = this.getTrackGroupArray(2);
        TrackGroup caption = null;
        if (captions != null && captions.length > index) {
            caption = captions.get(index);
        }
        return caption;
    }

    protected void destroy() {
        this.playerInstanceDefault = null;
        this.url = null;
        this.mediaSource = null;
        this.adsLoader = null;
    }
}

