/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RadioButton;
import android.widget.TextView;
import com.sambatech.player.R;
import com.sambatech.player.model.SambaMedia;
import java.util.List;

public class CastCaptionsAdapter
extends BaseAdapter {
    public int currentIndex = -1;
    private List<SambaMedia.Caption> captionsList;
    private Context cContext;

    public CastCaptionsAdapter(List<SambaMedia.Caption> captionsList, Context cContext) {
        this.captionsList = captionsList;
        this.cContext = cContext;
        this.currentIndex = captionsList.size() - 1;
    }

    public int getCount() {
        return this.captionsList.size();
    }

    public Object getItem(int i) {
        return this.captionsList.get(i);
    }

    public long getItemId(int i) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        CaptionItem holder;
        if (convertView == null) {
            convertView = ((LayoutInflater)this.cContext.getSystemService("layout_inflater")).inflate(R.layout.action_sheet_item, parent, false);
            holder = new CaptionItem(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (CaptionItem)convertView.getTag();
        }
        SambaMedia.Caption caption = (SambaMedia.Caption)this.getItem(position);
        if (caption.label != null && caption.label.length() > 0) {
            holder.label.setText((CharSequence)caption.label);
        } else {
            holder.label.setText((CharSequence)caption.language);
        }
        holder.radio.setChecked(this.currentIndex == position);
        return convertView;
    }

    private static class CaptionItem {
        TextView label;
        RadioButton radio;

        CaptionItem(View view) {
            this.radio = (RadioButton)view.findViewById(R.id.sheet_output_radio);
            this.label = (TextView)view.findViewById(R.id.sheet_item_label);
        }
    }
}

