/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.cast;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.google.android.exoplayer2.ui.PlaybackControlView;
import com.sambatech.player.R;
import com.sambatech.player.adapter.CastCaptionsAdapter;
import com.sambatech.player.cast.CastPlayer;
import com.sambatech.player.model.SambaMedia;
import com.sambatech.player.utils.OptionsMenuLayer;
import java.util.ArrayList;

public class CastOptionsMenu
implements OptionsMenuLayer.OptionsMenuCallback {
    private Context context;
    private FrameLayout container;
    private OptionsMenuLayer optionsMenuLayer;
    private CastPlayer castPlayer;
    private PlaybackControlView playbackControlView;
    private BottomSheetDialog outputSheetDialog;
    private BottomSheetDialog captionsSheetDialog;
    private BottomSheetDialog speedSheetDialog;
    private View outputSheetView;
    private View captionSheetView;
    private View speedSheetView;

    public CastOptionsMenu(FrameLayout container, Context context, CastPlayer castPlayer, PlaybackControlView playbackControlView, ArrayList<SambaMedia.Caption> captions) {
        this.container = container;
        this.context = context;
        this.castPlayer = castPlayer;
        this.playbackControlView = playbackControlView;
        this.optionsMenuLayer = new OptionsMenuLayer(context, (ViewGroup)container);
        this.container.addView((View)this.optionsMenuLayer, new ViewGroup.LayoutParams(-1, -1));
        this.container.bringChildToFront((View)this.optionsMenuLayer);
        this.optionsMenuLayer.setCallback(this);
        this.optionsMenuLayer.setHdButtonVisibility(false);
        this.optionsMenuLayer.setSpeedButtonVisibility(false);
        this.optionsMenuLayer.setCaptionsButtonVisibility(false);
        if (captions != null || captions.size() > 0) {
            this.optionsMenuLayer.setCaptionsButtonVisibility(true);
            this.initCaptionMenu(captions);
        }
    }

    public void show() {
        if (this.playbackControlView != null) {
            this.playbackControlView.hide();
        }
        if (this.optionsMenuLayer != null) {
            this.optionsMenuLayer.showMenu();
        }
    }

    public void hide() {
        if (this.playbackControlView != null) {
            this.playbackControlView.show();
        }
        if (this.optionsMenuLayer != null) {
            this.optionsMenuLayer.hideMenu();
        }
    }

    private void initCaptionMenu(final ArrayList<SambaMedia.Caption> captions) {
        this.captionSheetView = ((Activity)this.context).getLayoutInflater().inflate(R.layout.action_sheet, null);
        TextView title = (TextView)this.captionSheetView.findViewById(R.id.action_sheet_title);
        title.setText((CharSequence)this.context.getString(R.string.captions));
        final ListView menuList = (ListView)this.captionSheetView.findViewById(R.id.sheet_list);
        final CastCaptionsAdapter adapter = new CastCaptionsAdapter(captions, this.context);
        menuList.setAdapter((ListAdapter)adapter);
        menuList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                CastOptionsMenu.this.hide();
                CastOptionsMenu.this.captionsSheetDialog.dismiss();
                adapter.currentIndex = position;
                SambaMedia.Caption caption = (SambaMedia.Caption)captions.get(position);
                CastOptionsMenu.this.castPlayer.sendSubtitle(caption.language);
                menuList.smoothScrollToPosition(0);
                adapter.currentIndex = position;
            }
        });
        menuList.deferNotifyDataSetChanged();
        this.captionsSheetDialog = this.setupMenuDialog(this.captionSheetView);
    }

    public BottomSheetDialog setupMenuDialog(View view) {
        BottomSheetDialog bottomSheetDialog = new BottomSheetDialog(this.context);
        bottomSheetDialog.setContentView(view);
        bottomSheetDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                CastOptionsMenu.this.hide();
            }
        });
        BottomSheetBehavior bottomSheetBehavior = BottomSheetBehavior.from((View)((View)view.getParent()));
        bottomSheetBehavior.setHideable(false);
        bottomSheetBehavior.setPeekHeight(Integer.MAX_VALUE);
        return bottomSheetDialog;
    }

    @Override
    public void onTouchHD() {
    }

    @Override
    public void onTouchCaptions() {
        if (this.captionsSheetDialog == null) {
            return;
        }
        this.captionsSheetDialog.show();
    }

    @Override
    public void onTouchSpeed() {
    }

    @Override
    public void onMenuDismiss() {
        this.hide();
    }

    public void destroy() {
        this.container.removeView((View)this.optionsMenuLayer);
        this.optionsMenuLayer = null;
        this.outputSheetDialog = null;
        this.captionsSheetDialog = null;
        this.speedSheetDialog = null;
        this.outputSheetView = null;
        this.captionSheetView = null;
        this.speedSheetView = null;
    }
}

