/*
 * Decompiled with CFR 0.152.
 */
package com.sambatech.player.cast;

import com.google.android.gms.cast.MediaQueueItem;
import com.sambatech.player.cast.CastTimeline;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

final class CastTimelineTracker {
    private final HashMap<String, Long> contentIdToDurationUsMap = new HashMap();
    private final HashSet<String> scratchContentIdSet = new HashSet();

    public CastTimeline getCastTimeline(List<MediaQueueItem> items, String contentId, long durationUs) {
        this.removeUnusedDurationEntries(items);
        this.contentIdToDurationUsMap.put(contentId, durationUs);
        return new CastTimeline(items, this.contentIdToDurationUsMap);
    }

    private void removeUnusedDurationEntries(List<MediaQueueItem> items) {
        this.scratchContentIdSet.clear();
        for (MediaQueueItem item : items) {
            this.scratchContentIdSet.add(item.getMedia().getContentId());
        }
        this.contentIdToDurationUsMap.keySet().retainAll(this.scratchContentIdSet);
    }
}

